/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.hippoecm.hst.core.jcr.EventListenerItem;
import org.hippoecm.hst.core.jcr.EventListenersContainer;
import org.hippoecm.hst.core.jcr.EventListenersContainerListener;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.logging.LoggerFactory;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.NodeUtils;

public class EventListenersContainerImpl
implements EventListenersContainer {
    private static final String LOGGER_CATEGORY_NAME = EventListenersContainerImpl.class.getName();
    private static int eventListenersContainerSessionCheckerIndex;
    protected String name;
    protected Repository repository;
    protected Credentials credentials;
    protected Session session;
    protected boolean sessionLiveCheck;
    protected long sessionLiveCheckIntervalOnStartup = 3000L;
    protected long sessionLiveCheckInterval = 60000L;
    protected Workspace workspace;
    protected ObservationManager observationManager;
    protected List<EventListenerItem> eventListenerItems = Collections.synchronizedList(new LinkedList());
    protected boolean firstInitializationDone;
    protected EventListenersContainerSessionChecker eventListenersContainerSessionChecker;
    protected volatile boolean stopped;
    protected LoggerFactory loggerFactory;

    public EventListenersContainerImpl() {
        this(null);
    }

    public EventListenersContainerImpl(String name) {
        this.name = name;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventListenerItem> getEventListenerItems() {
        if (this.eventListenerItems == null) {
            return Collections.emptyList();
        }
        LinkedList<EventListenerItem> copiedEventListenerItems = null;
        List<EventListenerItem> list = this.eventListenerItems;
        synchronized (list) {
            copiedEventListenerItems = new LinkedList<EventListenerItem>(this.eventListenerItems);
        }
        return copiedEventListenerItems;
    }

    public synchronized void setEventListenerItems(List<EventListenerItem> eventListenerItems) {
        this.eventListenerItems = eventListenerItems;
    }

    public synchronized void addEventListenerItem(EventListenerItem eventListenerItem) {
        if (this.eventListenerItems == null) {
            this.eventListenerItems = Collections.synchronizedList(new LinkedList());
        }
        this.eventListenerItems.add(eventListenerItem);
    }

    public boolean removeEventListenerItem(EventListenerItem eventListenerItem) {
        if (this.eventListenerItems == null) {
            return false;
        }
        return this.eventListenerItems.remove(eventListenerItem);
    }

    public void setSessionLiveCheck(boolean sessionLiveCheck) {
        this.sessionLiveCheck = sessionLiveCheck;
    }

    public void setSessionLiveCheckIntervalOnStartup(long sessionLiveCheckIntervalOnStartup) {
        this.sessionLiveCheckIntervalOnStartup = sessionLiveCheckIntervalOnStartup;
    }

    public void setSessionLiveCheckInterval(long sessionLiveCheckInterval) {
        this.sessionLiveCheckInterval = sessionLiveCheckInterval;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    protected Logger getLogger() {
        if (this.loggerFactory != null) {
            return this.loggerFactory.getLogger(LOGGER_CATEGORY_NAME);
        }
        return HstServices.getLogger(LOGGER_CATEGORY_NAME);
    }

    public synchronized void start() {
        if (!this.sessionLiveCheck) {
            this.stopped = false;
            this.doDeinit();
            this.doInit();
        } else {
            this.stopped = true;
            if (this.eventListenersContainerSessionChecker != null) {
                block7: {
                    if (this.eventListenersContainerSessionChecker.isAlive()) {
                        try {
                            this.eventListenersContainerSessionChecker.interrupt();
                            this.eventListenersContainerSessionChecker.join(10000L);
                            this.getLogger().debug("EventListenersContainerSessionChecker is interrupted on start: {}", (Object)this.eventListenersContainerSessionChecker);
                        }
                        catch (Exception e) {
                            Logger log = this.getLogger();
                            if (log.isDebugEnabled()) {
                                log.warn("Exception occurred during interrupting eventListenersContainerSessionChecker thread.", (Throwable)e);
                            }
                            if (!log.isWarnEnabled()) break block7;
                            log.warn("Exception occurred during interrupting eventListenersContainerSessionChecker thread. {}", (Object)e.toString());
                        }
                    }
                }
                this.eventListenersContainerSessionChecker = null;
            }
            this.doDeinit();
            this.stopped = false;
            this.eventListenersContainerSessionChecker = new EventListenersContainerSessionChecker();
            this.getLogger().debug("EventListenersContainerSessionChecker is started: {}", (Object)this);
            this.eventListenersContainerSessionChecker.start();
        }
    }

    protected void doInit() {
        Logger log = this.getLogger();
        if (log.isDebugEnabled()) {
            log.debug("EventListenersContainer will initialize itself.");
        }
        try {
            EventListener eventListener;
            this.session = this.credentials == null ? this.repository.login() : this.repository.login(this.credentials);
            this.workspace = this.session.getWorkspace();
            this.observationManager = this.workspace.getObservationManager();
            for (EventListenerItem item : this.getEventListenerItems()) {
                eventListener = item.getEventListener();
                int eventTypes = item.getEventTypes();
                String absolutePath = item.getAbsolutePath();
                boolean isDeep = item.isDeep();
                Object[] uuids = item.getUuids();
                Object[] nodeTypeNames = item.getNodeTypeNames();
                boolean noLocal = item.isNoLocal();
                if (eventListener == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("event listener object is null. Just ignored.");
                    continue;
                }
                if (eventTypes <= 0) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("event listener's event types is invalid: {}. Just ignored.", (Object)eventTypes);
                    continue;
                }
                try {
                    this.observationManager.addEventListener(eventListener, eventTypes, absolutePath, isDeep, (String[])uuids, (String[])nodeTypeNames, noLocal);
                }
                catch (RepositoryException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to register event listener '" + eventListener + "': " + (Object)((Object)e), (Throwable)e);
                        continue;
                    }
                    log.warn("Failed to register event listener '" + eventListener + "': " + (Object)((Object)e));
                    continue;
                }
                boolean itemExistsOnAbsolutePath = false;
                try {
                    itemExistsOnAbsolutePath = this.session.itemExists(absolutePath);
                    if (itemExistsOnAbsolutePath) {
                        Node canonical;
                        Item jcrItem = this.session.getItem(absolutePath);
                        if (!jcrItem.isNode()) {
                            jcrItem = jcrItem.getParent();
                        }
                        if ((canonical = NodeUtils.getCanonicalNode((Node)jcrItem)) == null || !canonical.isSame(jcrItem)) {
                            log.warn("An event handler will be registered for a virtual node. Virtual nodes never have events. You should take the canonical location most likely. Virtual path = " + absolutePath);
                        }
                    }
                }
                catch (Exception anyEx) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to check if item exists on " + absolutePath + ": " + anyEx, (Throwable)anyEx);
                    }
                    log.warn("Failed to check if item exists on " + absolutePath + ": " + anyEx);
                }
                if (!itemExistsOnAbsolutePath) {
                    log.warn("An event handler will be registered for a path where no node currently is available: " + absolutePath);
                }
                if (!log.isInfoEnabled()) continue;
                log.info("An event listener registered: listener=" + eventListener + ", eventTypes=" + eventTypes + ", absolutePath=" + absolutePath + ", isDeep=" + isDeep + ", uuids=" + Arrays.toString(uuids) + ", nodeTypeNames=" + Arrays.toString(nodeTypeNames) + ", noLocal=" + noLocal);
            }
            if (!this.firstInitializationDone) {
                this.firstInitializationDone = true;
                for (EventListenerItem item : this.getEventListenerItems()) {
                    eventListener = item.getEventListener();
                    if (!(eventListener instanceof EventListenersContainerListener)) continue;
                    try {
                        ((EventListenersContainerListener)eventListener).onEventListenersContainerStarted();
                    }
                    catch (Exception elcle) {
                        if (log.isDebugEnabled()) {
                            log.warn("Failed to fire started event. " + elcle, (Throwable)elcle);
                            continue;
                        }
                        log.warn("Failed to fire started event. " + elcle);
                    }
                }
                log.info("EventListenersContainer's initialization done.");
            } else {
                for (EventListenerItem item : this.getEventListenerItems()) {
                    eventListener = item.getEventListener();
                    if (!(eventListener instanceof EventListenersContainerListener)) continue;
                    try {
                        ((EventListenersContainerListener)eventListener).onEventListenersContainerRefreshed();
                    }
                    catch (Exception elcle) {
                        if (log.isDebugEnabled()) {
                            log.warn("Failed to fire refreshed event. " + elcle, (Throwable)elcle);
                            continue;
                        }
                        log.warn("Failed to fire refreshed event. " + elcle);
                    }
                }
                log.info("EventListenersContainer's initialization done again.");
            }
        }
        catch (LoginException e) {
            if (this.firstInitializationDone) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to get a session in EventListenersContainer. The repository might be not available yet or the credentials might be wrong. It will try initialization next time. " + (Object)((Object)e), (Throwable)e);
                } else {
                    log.warn("Failed to get a session in EventListenersContainer. The repository might be not available yet or the credentials might be wrong. It will try initialization next time. " + (Object)((Object)e));
                }
            } else {
                log.info("Could not yet get a session in the EventListenersContainer. The repository still needs to be started. Will try again in '{}' ms.", (Object)String.valueOf(this.sessionLiveCheckIntervalOnStartup));
            }
        }
        catch (RepositoryException e) {
            if (this.firstInitializationDone) {
                if (log.isDebugEnabled()) {
                    log.warn("The repository is not available. It will try initialization next time. " + (Object)((Object)e), (Throwable)e);
                } else {
                    log.warn("The repository is not available. {} {}", (Object)"It will try initialization next time.", (Object)e);
                }
            }
            log.info("The repository is not yet available. The repository still needs to be started. Will try again in '{}' ms.", (Object)String.valueOf(this.sessionLiveCheckIntervalOnStartup));
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.doDeinit();
        if (this.eventListenersContainerSessionChecker != null) {
            block9: {
                if (this.eventListenersContainerSessionChecker.isAlive()) {
                    try {
                        this.eventListenersContainerSessionChecker.interrupt();
                        this.eventListenersContainerSessionChecker.join(10000L);
                        this.getLogger().debug("EventListenersContainerSessionChecker is interrupted on stop: {}", (Object)this.eventListenersContainerSessionChecker);
                    }
                    catch (Exception e) {
                        Logger log = this.getLogger();
                        if (log.isDebugEnabled()) {
                            log.warn("Exception occurred during interrupting eventListenersContainerSessionChecker thread", (Throwable)e);
                        }
                        if (!log.isWarnEnabled()) break block9;
                        log.warn("Exception occurred during interrupting eventListenersContainerSessionChecker thread. {}", (Object)e.toString());
                    }
                }
            }
            this.eventListenersContainerSessionChecker = null;
        }
        for (EventListenerItem item : this.getEventListenerItems()) {
            EventListener eventListener = item.getEventListener();
            if (!(eventListener instanceof EventListenersContainerListener)) continue;
            try {
                ((EventListenersContainerListener)eventListener).onEventListenersContainerStopped();
            }
            catch (Exception elcle) {
                Logger log = this.getLogger();
                if (log.isDebugEnabled()) {
                    log.warn("Failed to fire stopped event. " + elcle, (Throwable)elcle);
                    continue;
                }
                log.warn("Failed to fire stopped event. " + elcle);
            }
        }
    }

    protected void doDeinit() {
        if (this.observationManager != null) {
            for (EventListenerItem item : this.getEventListenerItems()) {
                Logger log;
                try {
                    EventListener eventListener = item.getEventListener();
                    if (eventListener == null) {
                        log = this.getLogger();
                        if (!log.isWarnEnabled()) continue;
                        log.warn("event listener object is null. Just ignored.");
                        continue;
                    }
                    this.observationManager.removeEventListener(eventListener);
                }
                catch (Exception e) {
                    log = this.getLogger();
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Cannot remove event listener. {}", (Object)e.toString());
                }
            }
        }
        if (this.session != null) {
            try {
                this.session.logout();
            }
            catch (Exception ce) {
                this.getLogger().debug("Exception while logging out jcr session: {}", (Object)ce.toString());
            }
        }
        this.observationManager = null;
        this.workspace = null;
        this.session = null;
    }

    protected class EventListenersContainerSessionChecker
    extends Thread {
        protected EventListenersContainerSessionChecker() {
            super((EventListenersContainerImpl.this.name != null ? EventListenersContainerImpl.this.name + "::" : "") + "EventListenersContainerSessionChecker-" + ++eventListenersContainerSessionCheckerIndex);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventListenersContainerImpl.this.getLogger().debug("EventListenersContainerSessionChecker starts running: {}", (Object)this);
            while (!EventListenersContainerImpl.this.stopped) {
                boolean isSessionLive = false;
                try {
                    if (EventListenersContainerImpl.this.session != null) {
                        isSessionLive = EventListenersContainerImpl.this.session.isLive();
                    }
                }
                catch (Exception e) {
                    EventListenersContainerImpl.this.getLogger().debug("Exception while checking jcr session: {}", (Object)e.toString());
                }
                if (EventListenersContainerImpl.this.stopped) break;
                if (!(EventListenersContainerImpl.this.session != null && isSessionLive || EventListenersContainerImpl.this.stopped)) {
                    EventListenersContainerImpl.this.doDeinit();
                    if (EventListenersContainerImpl.this.stopped) break;
                    EventListenersContainerImpl.this.doInit();
                    if (EventListenersContainerImpl.this.stopped) break;
                }
                EventListenersContainerSessionChecker eventListenersContainerSessionChecker = this;
                synchronized (eventListenersContainerSessionChecker) {
                    block10: {
                        try {
                            this.wait(EventListenersContainerImpl.this.firstInitializationDone ? EventListenersContainerImpl.this.sessionLiveCheckInterval : EventListenersContainerImpl.this.sessionLiveCheckIntervalOnStartup);
                        }
                        catch (InterruptedException e) {
                            if (!EventListenersContainerImpl.this.stopped) break block10;
                            break;
                        }
                    }
                }
            }
            EventListenersContainerImpl.this.getLogger().debug("EventListenersContainerSessionChecker stops running: {}", (Object)this);
        }
    }
}

