/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.hippoecm.hst.core.jcr.GenericEventListener;
import org.hippoecm.hst.site.HstServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AsynchronousDispatchingEventListener
extends GenericEventListener {
    static Logger log = LoggerFactory.getLogger(AsynchronousDispatchingEventListener.class);
    private ExecutorService executor;

    public AsynchronousDispatchingEventListener() {
        log.warn("{} extends from AsynchronousDispatchingEventListener which has been deprecated. Extend from GenericEventListener instead", (Object)((Object)((Object)this)).getClass().getName());
        this.executor = Executors.newSingleThreadExecutor();
    }

    public AsynchronousDispatchingEventListener(ExecutorService executor) {
        this.executor = executor;
    }

    public abstract void onAsynchronousEvent(EventIterator var1);

    public final void onEvent(EventIterator events) {
        ArrayList<DetachedEvent> detachedEventList = new ArrayList<DetachedEvent>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            String path = null;
            try {
                path = event.getPath();
                DetachedEvent detachedEvent = new DetachedEvent(event);
                detachedEventList.add(detachedEvent);
            }
            catch (RepositoryException e) {
                if (path == null) {
                    HstServices.getLogger(((Object)((Object)this)).getClass().getName()).warn("Repository exception during processing event. Could not getPath() for the event. Processing next event", (Throwable)e);
                    continue;
                }
                HstServices.getLogger(((Object)((Object)this)).getClass().getName()).warn("Repository exception during processing event with path '" + path + "'. Processing next event", (Throwable)e);
            }
        }
        DetachedEventIterator iterator = new DetachedEventIterator(detachedEventList.toArray(new Event[detachedEventList.size()]));
        this.executor.execute(new AsynchronousEventDispatcher(iterator, this));
    }

    private class DetachedEvent
    implements Event {
        final long date;
        final String identifier;
        final String path;
        final int type;
        final String userData;
        final String userID;

        public DetachedEvent(Event event) throws RepositoryException {
            this.date = event.getDate();
            this.identifier = event.getIdentifier();
            this.path = event.getPath();
            this.type = event.getType();
            this.userData = event.getUserData();
            this.userID = event.getUserID();
        }

        public long getDate() throws RepositoryException {
            return this.date;
        }

        public String getIdentifier() throws RepositoryException {
            return this.identifier;
        }

        public Map getInfo() throws RepositoryException {
            throw new UnsupportedOperationException("getInfo not supported on RepoDetachedEvent");
        }

        public String getPath() throws RepositoryException {
            return this.path;
        }

        public int getType() {
            return this.type;
        }

        public String getUserData() throws RepositoryException {
            return this.userData;
        }

        public String getUserID() {
            return this.userID;
        }
    }

    private class DetachedEventIterator
    implements EventIterator {
        private int position = 0;
        private final Event[] events;

        public DetachedEventIterator(Event[] events) {
            this.events = events;
        }

        public boolean hasNext() {
            return this.position < this.events.length;
        }

        public Event next() {
            return this.events[this.position++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long items) {
            this.position = (int)((long)this.position + items);
            if (this.position > this.events.length) {
                this.position = this.events.length;
                throw new NoSuchElementException("Skipped past the last element of the iterator");
            }
        }

        public long getSize() {
            return this.events.length;
        }

        public long getPosition() {
            return this.position;
        }

        public Event nextEvent() {
            return this.next();
        }
    }

    private class AsynchronousEventDispatcher
    implements Runnable {
        EventIterator events;
        AsynchronousDispatchingEventListener listener;

        private AsynchronousEventDispatcher(EventIterator events, AsynchronousDispatchingEventListener listener) {
            this.events = events;
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onAsynchronousEvent(this.events);
        }
    }
}

