/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionOptimizer {
    private CollectionOptimizer() {
    }

    public static <K, V> Map<K, V> optimizeHashMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        if (map.size() < 6) {
            HashMap<K, V> newMap = new HashMap<K, V>(map.size() * 4 / 3);
            newMap.putAll(map);
            map = newMap;
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> optimizeLinkedHashMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        if (map.size() < 6) {
            LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>(map.size() * 4 / 3);
            newMap.putAll(map);
            map = newMap;
        }
        return Collections.unmodifiableMap(map);
    }

    public static <V> Set<V> optimizeHashSet(Set<V> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        if (set.size() < 6) {
            HashSet<V> newSet = new HashSet<V>(set.size() * 4 / 3);
            newSet.addAll(set);
            set = newSet;
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> List<E> optimizeArrayList(List<E> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ((ArrayList)list).trimToSize();
        return Collections.unmodifiableList(list);
    }
}

