/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.hosting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.configuration.channel.Channel;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MutableMount;
import org.hippoecm.hst.configuration.hosting.MutablePortMount;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHost;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHosts;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.model.HstConfigurationAugmenter;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.service.ServiceException;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.HstRequestUtils;

public class CustomMountAndVirtualHostAugmenter
implements HstConfigurationAugmenter {
    private static final Logger log = HstServices.getLogger(CustomMountAndVirtualHostAugmenter.class.getName());
    private static final String DEFAULT_CUSTOM_HOST_NAME = "127.0.0.1";
    private static final String DEFAULT_NOOP_NAMED_PIPELINE = "NoopPipeline";
    private String customMountName = null;
    private String customMountNamedPipeline = null;
    private String customMountType = "live";
    private String customHostName = "127.0.0.1";
    private String noopPipeline = "NoopPipeline";
    private static final String fakeNonExistingPath = "/fakePath/" + UUID.randomUUID().toString();

    public void setCustomMountName(String customMountName) {
        this.customMountName = customMountName;
    }

    public void setCustomMountNamedPipeline(String customMountNamedPipeline) {
        this.customMountNamedPipeline = customMountNamedPipeline;
    }

    public void setCustomMountType(String customMountType) {
        this.customMountType = customMountType;
    }

    public void setCustomHostName(String customHostName) {
        this.customHostName = customHostName;
    }

    public void setNoopPipeline(String noopPipeline) {
        this.noopPipeline = noopPipeline;
    }

    public void augment(MutableVirtualHosts hosts) throws ContainerException {
        try {
            if (this.customMountName == null || this.customMountName.isEmpty()) {
                log.error("{} can only work when the customMountName is not null or empty.", (Object)this.getClass().getName());
                return;
            }
            if (this.customMountNamedPipeline == null || this.customMountNamedPipeline.isEmpty()) {
                log.error("{} can only work when the customMountNamedPipeline is not null or empty.", (Object)this.getClass().getName());
                return;
            }
            if (this.customHostName == null || this.customHostName.isEmpty()) {
                log.error("{} can only work when the customHostName is not null or empty.", (Object)this.getClass().getName());
                return;
            }
            String[] hostSegments = this.customHostName.split("\\.");
            CustomMountAndVirtualHostAugmenter.reverse(hostSegments);
            VirtualHost customHost = null;
            for (Map rootVirtualHostMap : hosts.getRootVirtualHostsByGroup().values()) {
                customHost = null;
                for (int i = 0; i < hostSegments.length && (customHost = i == 0 ? (VirtualHost)rootVirtualHostMap.get(hostSegments[i]) : customHost.getChildHost(hostSegments[i])) != null; ++i) {
                }
                if (customHost == null) continue;
                break;
            }
            if (customHost == null) {
                CustomVirtualHost cmsVirtualHost = new CustomVirtualHost((VirtualHosts)hosts, hostSegments, 0);
                hosts.addVirtualHost((MutableVirtualHost)cmsVirtualHost);
            } else if (customHost instanceof MutableVirtualHost) {
                PortMount portMount = customHost.getPortMount(0);
                if (portMount == null) {
                    CustomPortMount cmsRestPortMount = new CustomPortMount(customHost);
                    ((MutableVirtualHost)customHost).addPortMount((MutablePortMount)cmsRestPortMount);
                } else if (portMount instanceof MutablePortMount) {
                    Mount rootMount = portMount.getRootMount();
                    if (rootMount == null) {
                        CustomMount customRootMount = new CustomMount(customHost, this.noopPipeline);
                        ((MutablePortMount)portMount).setRootMount((MutableMount)customRootMount);
                    } else {
                        Mount customMount = rootMount.getChildMount(this.customMountName);
                        if (customMount != null) {
                            log.info("There is an implicit '{}' mount configured, hence no programmatic added custom mount", (Object)this.customMountName);
                        } else if (rootMount instanceof MutableMount) {
                            CustomMount newCmsRestMount = new CustomMount(this.customMountName, this.customMountNamedPipeline, this.customMountType, rootMount, customHost);
                            ((MutableMount)rootMount).addMount((MutableMount)newCmsRestMount);
                        } else {
                            log.error("Unable to add the custom mount {} for pipeline {}.", (Object)this.customMountName, (Object)this.customMountNamedPipeline);
                        }
                    }
                } else {
                    log.error("Unable to add the custom mount {} for pipeline {}.", (Object)this.customMountName, (Object)this.customMountNamedPipeline);
                }
            } else {
                log.error("Unable to add the custom mount {} for pipeline {}.", (Object)this.customMountName, (Object)this.customMountNamedPipeline);
            }
        }
        catch (ServiceException e) {
            log.error("Unable to add the custom mount " + this.customMountName + "  for pipeline " + this.customMountNamedPipeline + ".", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to add the custom mount " + this.customMountName + "  for pipeline " + this.customMountNamedPipeline + ". It might already be explicitly configured.", (Throwable)e);
        }
    }

    static void reverse(String[] s) {
        List<String> l = Arrays.asList(s);
        Collections.reverse(l);
    }

    private class CustomMount
    implements MutableMount {
        private VirtualHost virtualHost;
        private Mount parent;
        private String alias = "randomAlias" + UUID.randomUUID().toString();
        private String identifier = "randomIdentifier" + UUID.randomUUID().toString();
        private String name;
        private String namedPipeline;
        private String type;
        private Map<String, Mount> childs = new HashMap<String, Mount>();
        private String mountPath;
        private List<String> types;

        private CustomMount(VirtualHost virtualHost, String namedPipeline) throws ServiceException {
            this.virtualHost = virtualHost;
            this.name = "hst:root";
            this.mountPath = "";
            this.namedPipeline = namedPipeline;
            this.type = CustomMountAndVirtualHostAugmenter.this.customMountType;
            this.types = Collections.singletonList(CustomMountAndVirtualHostAugmenter.this.customMountType);
            CustomMount customMount = new CustomMount(CustomMountAndVirtualHostAugmenter.this.customMountName, CustomMountAndVirtualHostAugmenter.this.customMountNamedPipeline, CustomMountAndVirtualHostAugmenter.this.customMountType, (Mount)this, virtualHost);
            this.childs.put(customMount.getName(), (Mount)customMount);
            ((MutableVirtualHosts)virtualHost.getVirtualHosts()).addMount((Mount)this);
        }

        public CustomMount(String name, String namedPipeline, String type, Mount parent, VirtualHost virtualHost) throws ServiceException {
            this.name = name;
            this.namedPipeline = namedPipeline;
            this.type = type;
            this.types = Collections.singletonList(type);
            this.parent = parent;
            this.virtualHost = virtualHost;
            ((MutableVirtualHosts)virtualHost.getVirtualHosts()).addMount((Mount)this);
            this.mountPath = parent.getMountPath() + "/" + name;
        }

        public void addMount(MutableMount mount) throws IllegalArgumentException, ServiceException {
            if (this.childs.containsKey(mount.getName())) {
                throw new IllegalArgumentException("Cannot add Mount with name '" + mount.getName() + "' because it already exists for " + this.toString());
            }
            this.childs.put(mount.getName(), (Mount)mount);
            ((MutableVirtualHosts)this.virtualHost.getVirtualHosts()).addMount((Mount)mount);
        }

        public String getNamedPipeline() {
            return this.namedPipeline;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isMapped() {
            return false;
        }

        public Mount getParent() {
            return this.parent;
        }

        public List<Mount> getChildMounts() {
            return Collections.unmodifiableList(new ArrayList<Mount>(this.childs.values()));
        }

        public Mount getChildMount(String name) {
            return this.childs.get(name);
        }

        public VirtualHost getVirtualHost() {
            return this.virtualHost;
        }

        public HstSite getHstSite() {
            return null;
        }

        public boolean isContextPathInUrl() {
            return false;
        }

        public boolean isPortInUrl() {
            return false;
        }

        public boolean isSite() {
            return false;
        }

        public int getPort() {
            return 0;
        }

        public String onlyForContextPath() {
            return this.getVirtualHost().onlyForContextPath();
        }

        public boolean isAuthenticated() {
            return false;
        }

        public Set<String> getRoles() {
            return null;
        }

        public Set<String> getUsers() {
            return null;
        }

        public boolean isSubjectBasedSession() {
            return false;
        }

        public boolean isSessionStateful() {
            return false;
        }

        public String getMountPoint() {
            return null;
        }

        public String getContentPath() {
            return fakeNonExistingPath;
        }

        public String getCanonicalContentPath() {
            return fakeNonExistingPath;
        }

        public String getMountPath() {
            return this.mountPath;
        }

        public String getHomePage() {
            return null;
        }

        public String getPageNotFound() {
            return null;
        }

        public String getScheme() {
            return "http";
        }

        public boolean isSchemeAgnostic() {
            return true;
        }

        public boolean containsMultipleSchemes() {
            return false;
        }

        public int getSchemeNotMatchingResponseCode() {
            return 200;
        }

        public boolean isPreview() {
            return false;
        }

        public boolean isOfType(String type) {
            return this.getTypes().contains(type);
        }

        public String getType() {
            return this.type;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public boolean isVersionInPreviewHeader() {
            return false;
        }

        public String getLocale() {
            return null;
        }

        public HstSiteMapMatcher getHstSiteMapMatcher() {
            return null;
        }

        public String getFormLoginPage() {
            return null;
        }

        public String getProperty(String name) {
            return null;
        }

        public Map<String, String> getMountProperties() {
            return Collections.emptyMap();
        }

        public String getParameter(String name) {
            return null;
        }

        public Map<String, String> getParameters() {
            return Collections.emptyMap();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public <T extends ChannelInfo> T getChannelInfo() {
            return null;
        }

        public String getChannelPath() {
            return null;
        }

        public Channel getChannel() {
            return null;
        }

        public String[] getDefaultSiteMapItemHandlerIds() {
            return null;
        }

        public boolean isCacheable() {
            return false;
        }

        public String getDefaultResourceBundleId() {
            return null;
        }

        public void setChannelInfo(ChannelInfo info) {
        }

        public void setChannel(Channel channel) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support setChannel");
        }

        @Deprecated
        public String getLockedBy() {
            return null;
        }

        @Deprecated
        public void setLockedBy(String userId) {
            throw new UnsupportedOperationException("CustomMount does not support locking");
        }

        @Deprecated
        public Calendar getLockedOn() {
            return null;
        }

        @Deprecated
        public void setLockedOn(Calendar lockedOn) {
            throw new UnsupportedOperationException("CustomMount does not support locking");
        }

        public String toString() {
            return "CustomMount [virtualHost=" + this.virtualHost.getHostName() + ", alias=" + this.alias + ", identifier=" + this.identifier + ", name=" + this.name + ", namedPipeline=" + this.namedPipeline + ", childs=" + this.childs + ", mountPath=" + this.mountPath + ", types=" + this.types + ", getAlias()=" + this.getAlias() + ", isMapped()=" + this.isMapped() + ", isPortInUrl()=" + this.isPortInUrl() + ", isSite()=" + this.isSite() + ", getPort()=" + this.getPort() + ", onlyForContextPath()=" + this.onlyForContextPath() + ", getType()=" + this.getType() + ", getIdentifier()=" + this.getIdentifier() + "]";
        }

        public String getCmsLocation() {
            return null;
        }
    }

    private class CustomPortMount
    implements MutablePortMount {
        private static final int PORT = 0;
        private Mount rootMount;

        private CustomPortMount(VirtualHost virtualHost) throws ServiceException {
            this.rootMount = new CustomMount(virtualHost, CustomMountAndVirtualHostAugmenter.this.noopPipeline);
        }

        public int getPortNumber() {
            return 0;
        }

        public Mount getRootMount() {
            return this.rootMount;
        }

        public void setRootMount(MutableMount mount) {
            this.rootMount = mount;
        }

        public String toString() {
            return "CustomPortMount [port=0]";
        }
    }

    private class CustomVirtualHost
    implements MutableVirtualHost {
        private VirtualHosts virtualHosts;
        private Map<String, VirtualHost> childs = new HashMap<String, VirtualHost>();
        private String name;
        private String hostName;
        private MutablePortMount portMount;

        private CustomVirtualHost(VirtualHosts virtualHosts, String[] hostSegments, int position) throws ServiceException {
            this.virtualHosts = virtualHosts;
            this.name = hostSegments[position];
            for (int i = position; i > -1; --i) {
                this.hostName = this.hostName != null ? this.hostName + "." + hostSegments[i] : hostSegments[i];
            }
            if (++position == hostSegments.length) {
                this.portMount = new CustomPortMount((VirtualHost)this);
                this.setPortMount(this.portMount);
            } else {
                this.childs.put(hostSegments[position], (VirtualHost)new CustomVirtualHost(virtualHosts, hostSegments, position));
            }
        }

        public void addVirtualHost(MutableVirtualHost virtualHost) throws IllegalArgumentException {
            if (this.childs.containsKey(virtualHost.getName())) {
                throw new IllegalArgumentException("virtualHost '" + virtualHost.getName() + "' already exists");
            }
            this.childs.put(virtualHost.getName(), (VirtualHost)virtualHost);
        }

        public PortMount getPortMount(int portNumber) {
            return this.portMount;
        }

        public void setPortMount(MutablePortMount portMount) {
            this.portMount = portMount;
        }

        public void addPortMount(MutablePortMount portMount) throws IllegalArgumentException {
            log.warn("Cannot add a portMount to a CustomVirtualHost");
        }

        public String onlyForContextPath() {
            return this.virtualHosts.getDefaultContextPath();
        }

        public boolean isPortInUrl() {
            return false;
        }

        public boolean isContextPathInUrl() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getHostGroupName() {
            return CustomMountAndVirtualHostAugmenter.class.getName();
        }

        public List<VirtualHost> getChildHosts() {
            return Collections.unmodifiableList(new ArrayList<VirtualHost>(this.childs.values()));
        }

        public VirtualHost getChildHost(String name) {
            return this.childs.get(name);
        }

        public VirtualHosts getVirtualHosts() {
            return this.virtualHosts;
        }

        public String getScheme() {
            return "http";
        }

        public boolean isSchemeAgnostic() {
            return true;
        }

        public int getSchemeNotMatchingResponseCode() {
            return 200;
        }

        public String getPageNotFound() {
            return null;
        }

        public String getLocale() {
            return null;
        }

        public String getHomePage() {
            return null;
        }

        public String getBaseURL(HttpServletRequest request) {
            StringBuilder builder = new StringBuilder();
            builder.append(HstRequestUtils.getFarthestRequestScheme(request));
            builder.append("://").append(HstRequestUtils.getFarthestRequestHost(request, false));
            return builder.toString();
        }

        public boolean isVersionInPreviewHeader() {
            return false;
        }

        public String getCmsLocation() {
            return null;
        }

        public boolean isCacheable() {
            return false;
        }

        public String getDefaultResourceBundleId() {
            return null;
        }

        public String toString() {
            return "CustomVirtualHost [name=" + this.name + ", hostName=" + this.hostName + ", hostGroupName=" + this.getHostGroupName() + "]";
        }
    }
}

