/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.hosting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.configuration.channel.Channel;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MutableMount;
import org.hippoecm.hst.configuration.hosting.MutablePortMount;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHost;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHosts;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.model.HstConfigurationAugmenter;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.service.ServiceException;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.HstRequestUtils;

public class CustomMountAndVirtualCmsHostAugmenter
implements HstConfigurationAugmenter {
    private static final Logger log = HstServices.getLogger(CustomMountAndVirtualCmsHostAugmenter.class.getName());
    private static final String DEFAULT_NOOP_NAMED_PIPELINE = "NoopPipeline";
    private static final String AUGMENTED_CMS_VIRTUAL_HOST_GROUP = CustomMountAndVirtualCmsHostAugmenter.class.getName() + "-" + UUID.randomUUID();
    private String springConfiguredCmsLocation;
    private String mountName;
    private String mountType;
    private String mountNamedPipeline;
    private String noopPipeline = "NoopPipeline";
    private static final String fakeNonExistingPath = "/fakePath/" + UUID.randomUUID().toString();

    public void setSpringConfiguredCmsLocation(String springConfiguredCmsLocation) {
        this.springConfiguredCmsLocation = springConfiguredCmsLocation;
    }

    public void setMountName(String mountName) {
        this.mountName = mountName;
    }

    public void setMountNamedPipeline(String mountNamedPipeline) {
        this.mountNamedPipeline = mountNamedPipeline;
    }

    public void setMountType(String mountType) {
        this.mountType = mountType;
    }

    public void setNoopPipeline(String noopPipeline) {
        this.noopPipeline = noopPipeline;
    }

    public void augment(MutableVirtualHosts hosts) throws ContainerException {
        if (!this.validateState()) {
            return;
        }
        HashSet<String> cmsLocations = new HashSet<String>();
        for (Map rootVirtualHosts : hosts.getRootVirtualHostsByGroup().values()) {
            MutableVirtualHost host;
            if (rootVirtualHosts.isEmpty() || (host = (MutableVirtualHost)rootVirtualHosts.values().iterator().next()).getCmsLocation() == null) continue;
            cmsLocations.add(host.getCmsLocation());
        }
        if (cmsLocations.isEmpty() && this.springConfiguredCmsLocation != null) {
            log.info("No cms locations configured on hst:hostgroup nodes. Use the cms location '{}' from Spring configuration", cmsLocations);
            cmsLocations.add(this.springConfiguredCmsLocation);
        }
        for (String cmsLocation : cmsLocations) {
            try {
                URI uri = new URI(cmsLocation);
                String cmsCustomMountHostName = uri.getHost();
                String[] hostSegments = cmsCustomMountHostName.split("\\.");
                CustomMountAndVirtualCmsHostAugmenter.reverse(hostSegments);
                CustomVirtualHost host = null;
                for (Map rootVirtualHostMap : hosts.getRootVirtualHostsByGroup().values()) {
                    host = null;
                    for (int i = 0; i < hostSegments.length && (host = i == 0 ? (VirtualHost)rootVirtualHostMap.get(hostSegments[i]) : host.getChildHost(hostSegments[i])) != null; ++i) {
                    }
                    if (host == null) continue;
                    PortMount portMount = null;
                    int port = uri.getPort();
                    if (port != 0) {
                        portMount = host.getPortMount(port);
                    }
                    if (portMount == null) {
                        portMount = host.getPortMount(0);
                    }
                    if (portMount == null || portMount.getRootMount() == null) continue;
                }
                if (host == null) {
                    CustomVirtualHost newHost = new CustomVirtualHost((VirtualHosts)hosts, hostSegments, cmsLocation, 0);
                    hosts.addVirtualHost((MutableVirtualHost)newHost);
                    host = newHost;
                    while (!host.getChildHosts().isEmpty()) {
                        host = (VirtualHost)host.getChildHosts().get(0);
                    }
                }
                Object portMount = null;
                int port = uri.getPort();
                if (port != 0) {
                    portMount = host.getPortMount(port);
                }
                if (portMount == null) {
                    portMount = host.getPortMount(0);
                }
                if (portMount == null) {
                    portMount = port == -1 ? new CustomPortMount(0) : new CustomPortMount(port);
                    if (host instanceof CustomVirtualHost) {
                        host.setPortMount((MutablePortMount)portMount);
                    } else {
                        ((MutableVirtualHost)host).addPortMount((MutablePortMount)portMount);
                    }
                }
                Mount rootMount = portMount.getRootMount();
                Object customMount = null;
                if (rootMount == null) {
                    CustomMount rootMountPlusCustomMount = new CustomMount((VirtualHost)host, this.mountType, this.noopPipeline);
                    if (!(portMount instanceof MutablePortMount)) {
                        log.error("Unable to add custom mount '{}' to the host group with CMS location '{}' because found portMount not of type MutablePortMount.", (Object)this.mountName, (Object)cmsLocation);
                        continue;
                    }
                    ((MutablePortMount)portMount).setRootMount((MutableMount)rootMountPlusCustomMount);
                } else {
                    customMount = rootMount.getChildMount(this.mountName);
                    if (customMount == null) {
                        if (!(rootMount instanceof MutableMount)) {
                            log.error("Unable to add custom mount '{}' to the host group with CMS location '{}' because found rootMount not of type MutableMount.", (Object)this.mountName, (Object)cmsLocation);
                            continue;
                        }
                        customMount = new CustomMount(this.mountName, this.mountType, this.mountNamedPipeline, rootMount, (VirtualHost)host);
                        ((MutableMount)rootMount).addMount((MutableMount)customMount);
                    } else {
                        log.info("There is an explicit custom Mount '{}' for CMS location '{}'. This mount can be removed from configuration as it will be auto-created by the HST", (Object)this.mountName, (Object)cmsLocation);
                        continue;
                    }
                }
                if (customMount == null) continue;
                log.info("Successfully automatically created custom mount for cmsLocation '{}'. Created Mount = {}", (Object)cmsLocation, customMount);
            }
            catch (URISyntaxException e) {
                log.warn("'{}' is an invalid cmsLocation. The mount '{}' won't be available for hosts in that hostGroup.", (Object)cmsLocation, (Object)this.mountName);
            }
            catch (ServiceException e) {
                log.error("Unable to add custom cms host mount '" + this.mountName + "'.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to add custom cms host mount '" + this.mountName + "'. Illegal argument: " + e.getMessage());
            }
        }
    }

    private boolean validateState() throws ContainerException {
        if (this.mountName == null || this.mountName.isEmpty()) {
            log.error("No mount name set for {}", (Object)this.getClass().getName());
            return false;
        }
        if (this.mountType == null || this.mountType.isEmpty()) {
            log.error("No mount type set for {}", (Object)this.getClass().getName());
            return false;
        }
        if (this.mountNamedPipeline == null || this.mountNamedPipeline.isEmpty()) {
            log.error("No mount named pipeline set for {}", (Object)this.getClass().getName());
            return false;
        }
        return true;
    }

    static void reverse(String[] s) {
        List<String> l = Arrays.asList(s);
        Collections.reverse(l);
    }

    private class CustomMount
    implements MutableMount {
        private VirtualHost virtualHost;
        private Mount parent;
        private String alias = "randomAlias" + UUID.randomUUID().toString();
        private String identifier = "randomIdentifer" + UUID.randomUUID().toString();
        private String name;
        private String namedPipeline;
        private Map<String, Mount> childs = new HashMap<String, Mount>();
        private String mountPath;
        private String type;
        private List<String> types;

        private CustomMount(VirtualHost virtualHost, String type, String namedPipeline) throws ServiceException {
            this.virtualHost = virtualHost;
            this.name = "hst:root";
            this.mountPath = "";
            type = "live";
            this.types = Arrays.asList(type);
            this.namedPipeline = namedPipeline;
            CustomMount customRootMount = new CustomMount(CustomMountAndVirtualCmsHostAugmenter.this.mountName, type, CustomMountAndVirtualCmsHostAugmenter.this.mountNamedPipeline, (Mount)this, virtualHost);
            this.childs.put(customRootMount.getName(), (Mount)customRootMount);
            ((MutableVirtualHosts)virtualHost.getVirtualHosts()).addMount((Mount)this);
        }

        public CustomMount(String name, String type, String namedPipeline, Mount parent, VirtualHost virtualHost) throws ServiceException {
            this.name = name;
            this.namedPipeline = namedPipeline;
            this.parent = parent;
            this.type = type;
            this.types = Arrays.asList(type);
            this.virtualHost = virtualHost;
            this.mountPath = parent.getMountPath() + "/" + name;
        }

        public void addMount(MutableMount mount) throws IllegalArgumentException, ServiceException {
            if (this.childs.containsKey(mount.getName())) {
                throw new IllegalArgumentException("Cannot add Mount with name '" + mount.getName() + "' because already exists for " + this.toString());
            }
            this.childs.put(mount.getName(), (Mount)mount);
            ((MutableVirtualHosts)this.virtualHost.getVirtualHosts()).addMount((Mount)this);
        }

        public String getNamedPipeline() {
            return this.namedPipeline;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isMapped() {
            return false;
        }

        public Mount getParent() {
            return this.parent;
        }

        public List<Mount> getChildMounts() {
            return Collections.unmodifiableList(new ArrayList<Mount>(this.childs.values()));
        }

        public Mount getChildMount(String name) {
            return this.childs.get(name);
        }

        public VirtualHost getVirtualHost() {
            return this.virtualHost;
        }

        public HstSite getHstSite() {
            return null;
        }

        public boolean isContextPathInUrl() {
            return false;
        }

        public boolean isPortInUrl() {
            return false;
        }

        public boolean isSite() {
            return false;
        }

        public int getPort() {
            return 0;
        }

        public String onlyForContextPath() {
            return this.getVirtualHost().onlyForContextPath();
        }

        public boolean isAuthenticated() {
            return false;
        }

        public Set<String> getRoles() {
            return null;
        }

        public Set<String> getUsers() {
            return null;
        }

        public boolean isSubjectBasedSession() {
            return false;
        }

        public boolean isSessionStateful() {
            return false;
        }

        public String getMountPoint() {
            return null;
        }

        public String getContentPath() {
            return fakeNonExistingPath;
        }

        public String getCanonicalContentPath() {
            return fakeNonExistingPath;
        }

        public String getMountPath() {
            return this.mountPath;
        }

        public String getHomePage() {
            return null;
        }

        public String getPageNotFound() {
            return null;
        }

        public String getScheme() {
            return "http";
        }

        public boolean isSchemeAgnostic() {
            return true;
        }

        public boolean containsMultipleSchemes() {
            return false;
        }

        public int getSchemeNotMatchingResponseCode() {
            return 200;
        }

        public boolean isPreview() {
            return false;
        }

        public boolean isOfType(String type) {
            return this.getTypes().contains(type);
        }

        public String getType() {
            return this.type;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public boolean isVersionInPreviewHeader() {
            return false;
        }

        public String getLocale() {
            return null;
        }

        public HstSiteMapMatcher getHstSiteMapMatcher() {
            return null;
        }

        public String getFormLoginPage() {
            return null;
        }

        public String getProperty(String name) {
            return null;
        }

        public Map<String, String> getMountProperties() {
            return Collections.emptyMap();
        }

        public String getParameter(String name) {
            return null;
        }

        public Map<String, String> getParameters() {
            return Collections.emptyMap();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public <T extends ChannelInfo> T getChannelInfo() {
            return null;
        }

        public String getChannelPath() {
            return null;
        }

        public Channel getChannel() {
            return null;
        }

        public String[] getDefaultSiteMapItemHandlerIds() {
            return null;
        }

        public boolean isCacheable() {
            return false;
        }

        public String getDefaultResourceBundleId() {
            return null;
        }

        public void setChannelInfo(ChannelInfo info) {
        }

        public void setChannel(Channel channel) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support setChannel");
        }

        public String toString() {
            return "CustomMount [virtualHost=" + this.virtualHost.getHostName() + ", parent=" + this.parent.getName() + ", alias=" + this.alias + ", identifier=" + this.identifier + ", name=" + this.name + ", namedPipeline=" + this.namedPipeline + ", childs=" + this.childs + ", mountPath=" + this.mountPath + ", types=" + this.types + ", getAlias()=" + this.getAlias() + ", isMapped()=" + this.isMapped() + ", isPortInUrl()=" + this.isPortInUrl() + ", isSite()=" + this.isSite() + ", getPort()=" + this.getPort() + ", onlyForContextPath()=" + this.onlyForContextPath() + ", getType()=" + this.getType() + ", getIdentifier()=" + this.getIdentifier() + "]";
        }

        public String getCmsLocation() {
            if (this.virtualHost instanceof MutableVirtualHost) {
                return ((MutableVirtualHost)this.virtualHost).getCmsLocation();
            }
            log.warn("Can only get cms location of a MutableVirtualHost. '{}' is not a MutableVirtualHost", (Object)this.virtualHost);
            return null;
        }

        @Deprecated
        public String getLockedBy() {
            return null;
        }

        @Deprecated
        public void setLockedBy(String userId) {
            throw new UnsupportedOperationException("CustomMount does not support locking");
        }

        @Deprecated
        public Calendar getLockedOn() {
            return null;
        }

        @Deprecated
        public void setLockedOn(Calendar lockedOn) {
            throw new UnsupportedOperationException("CustomMount does not support locking");
        }
    }

    private class CustomPortMount
    implements MutablePortMount {
        private int port;
        private Mount rootMount;

        private CustomPortMount(int port) throws ServiceException {
            this.port = port;
        }

        public int getPortNumber() {
            return this.port;
        }

        public Mount getRootMount() {
            return this.rootMount;
        }

        public void setRootMount(MutableMount mount) {
            this.rootMount = mount;
        }

        public String toString() {
            return "CustomPortMount [port=" + this.port + "]";
        }
    }

    private class CustomVirtualHost
    implements MutableVirtualHost {
        private VirtualHosts virtualHosts;
        private Map<String, VirtualHost> childs = new HashMap<String, VirtualHost>();
        private String name;
        private String hostName;
        private MutablePortMount portMount;
        private String cmsLocation;

        private CustomVirtualHost(VirtualHosts virtualHosts, String[] hostSegments, String cmsLocation, int position) throws ServiceException {
            this.virtualHosts = virtualHosts;
            this.name = hostSegments[position];
            this.cmsLocation = cmsLocation;
            for (int i = position; i > -1; --i) {
                this.hostName = this.hostName != null ? this.hostName + "." + hostSegments[i] : hostSegments[i];
            }
            if (++position != hostSegments.length) {
                this.childs.put(hostSegments[position], (VirtualHost)new CustomVirtualHost(virtualHosts, hostSegments, cmsLocation, position));
            }
        }

        public void addVirtualHost(MutableVirtualHost virtualHost) throws IllegalArgumentException {
            if (this.childs.containsKey(virtualHost.getName())) {
                throw new IllegalArgumentException("virtualHost '" + virtualHost.getName() + "' already exists");
            }
            this.childs.put(virtualHost.getName(), (VirtualHost)virtualHost);
        }

        public PortMount getPortMount(int portNumber) {
            return this.portMount;
        }

        public void setPortMount(MutablePortMount portMount) {
            this.portMount = portMount;
        }

        public void addPortMount(MutablePortMount portMount) throws IllegalArgumentException {
            log.warn("Cannot add a portMount to a CmsRestVirtualHost");
        }

        public String onlyForContextPath() {
            return this.virtualHosts.getDefaultContextPath();
        }

        public boolean isPortInUrl() {
            return false;
        }

        public boolean isContextPathInUrl() {
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getHostGroupName() {
            return AUGMENTED_CMS_VIRTUAL_HOST_GROUP;
        }

        public List<VirtualHost> getChildHosts() {
            return Collections.unmodifiableList(new ArrayList<VirtualHost>(this.childs.values()));
        }

        public VirtualHost getChildHost(String name) {
            return this.childs.get(name);
        }

        public VirtualHosts getVirtualHosts() {
            return this.virtualHosts;
        }

        public String getScheme() {
            return "http";
        }

        public boolean isSchemeAgnostic() {
            return true;
        }

        public int getSchemeNotMatchingResponseCode() {
            return 200;
        }

        public String getPageNotFound() {
            return null;
        }

        public String getLocale() {
            return null;
        }

        public String getHomePage() {
            return null;
        }

        public String getBaseURL(HttpServletRequest request) {
            StringBuilder builder = new StringBuilder();
            String scheme = HstRequestUtils.getFarthestRequestScheme(request);
            String serverName = HstRequestUtils.getFarthestRequestHost(request, false);
            builder.append(scheme);
            builder.append("://").append(serverName);
            return builder.toString();
        }

        public boolean isVersionInPreviewHeader() {
            return false;
        }

        public boolean isCacheable() {
            return false;
        }

        public String getDefaultResourceBundleId() {
            return null;
        }

        public String getCmsLocation() {
            return this.cmsLocation;
        }

        public String toString() {
            return "CustomVirtualHost [name=" + this.name + ", hostName=" + this.hostName + "]";
        }
    }
}

