/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.core.component.WrapperElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class WrapperElementImpl
implements WrapperElement {
    private static final long serialVersionUID = 1L;
    private String tagName;
    private Map<String, String> attributes;
    private String textContent;

    public WrapperElementImpl() {
    }

    public WrapperElementImpl(String tagName) {
        this.tagName = tagName;
    }

    public WrapperElementImpl(Element element) {
        this.tagName = element.getTagName();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        } else {
            this.attributes.clear();
        }
        NamedNodeMap attrs = element.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            this.attributes.put(attr.getName(), attr.getValue());
        }
        this.textContent = element.getTextContent();
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(name);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public Object clone() throws CloneNotSupportedException {
        WrapperElementImpl cloned = (WrapperElementImpl)super.clone();
        cloned.tagName = this.tagName;
        cloned.attributes = new HashMap<String, String>(this.attributes);
        cloned.textContent = this.textContent;
        return cloned;
    }
}

