/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializableElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tagName;
    private Map<String, String> attributes;
    private String textContent;
    private Collection<SerializableElement> childElements;

    public SerializableElement() {
    }

    public SerializableElement(String tagName) {
        this.tagName = tagName;
    }

    public SerializableElement(Element element) {
        this.tagName = element.getTagName();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        } else {
            this.attributes.clear();
        }
        NamedNodeMap attrs = element.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            this.attributes.put(attr.getName(), attr.getValue());
        }
        this.textContent = element.getTextContent();
        NodeList nodeList = element.getChildNodes();
        length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (this.childElements == null) {
                this.childElements = new ArrayList<SerializableElement>();
            }
            this.childElements.add(new SerializableElement((Element)node));
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(name);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public boolean hasChildElements() {
        return this.childElements != null && !this.childElements.isEmpty();
    }

    public Collection<? extends SerializableElement> getChildElements() {
        if (this.childElements != null) {
            return this.childElements;
        }
        return Collections.emptyList();
    }

    public Object clone() throws CloneNotSupportedException {
        SerializableElement cloned = (SerializableElement)super.clone();
        cloned.tagName = this.tagName;
        cloned.attributes = new HashMap<String, String>(this.attributes);
        cloned.textContent = this.textContent;
        if (this.childElements != null) {
            cloned.childElements = new ArrayList<SerializableElement>();
            for (SerializableElement child : this.childElements) {
                cloned.childElements.add((SerializableElement)child.clone());
            }
        }
        return cloned;
    }
}

