/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstResponseState;
import org.hippoecm.hst.core.component.WrapperElementImpl;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.util.DefaultKeyValue;
import org.hippoecm.hst.util.HstRequestUtils;
import org.hippoecm.hst.util.KeyValue;
import org.hippoecm.hst.util.WrapperElementUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HstServletResponseState
implements HstResponseState {
    protected boolean isActionResponse;
    protected boolean isRenderResponse;
    protected boolean isResourceResponse;
    protected boolean isMimeResponse;
    protected boolean isStateAwareResponse;
    protected Locale defaultLocale;
    protected boolean flushed;
    protected ByteArrayOutputStream byteOutputBuffer;
    protected CharArrayWriterBuffer charOutputBuffer;
    protected ServletOutputStream outputStream;
    protected PrintWriter printWriter;
    protected Map<String, List<String>> addedHeaders;
    protected Map<String, List<String>> setHeaders;
    protected List<Cookie> cookies;
    protected List<KeyValue<String, Element>> headElements;
    protected List<Comment> preambleComments;
    protected List<Element> preambleElements;
    protected Element wrapperElement;
    protected boolean committed;
    protected boolean hasStatus;
    protected boolean hasError;
    protected Locale locale;
    protected boolean setContentTypeAfterEncoding;
    protected boolean closed;
    protected String characterEncoding;
    protected int contentLength = -1;
    protected String contentType;
    protected int errorCode;
    protected String errorMessage;
    protected int statusCode;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private String redirectLocation;
    private String forwardPathInfo;

    public HstServletResponseState(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        HstRequestContext requestContext = HstRequestUtils.getHstRequestContext(request);
        this.isActionResponse = requestContext.getBaseURL().getActionWindowReferenceNamespace() != null;
        this.isResourceResponse = requestContext.getBaseURL().getResourceWindowReferenceNamespace() != null;
        this.isRenderResponse = !this.isActionResponse && !this.isResourceResponse;
        this.isStateAwareResponse = this.isActionResponse;
        this.isMimeResponse = this.isRenderResponse || this.isResourceResponse;
    }

    public Element createElement(String tagName) {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            return doc.createElement(tagName);
        }
        catch (ParserConfigurationException e) {
            throw new DOMException(0, "Initialization failure");
        }
    }

    protected List<String> getAddedHeaderList(String name, boolean create) {
        List<String> headerList;
        if (this.addedHeaders == null) {
            this.addedHeaders = new HashMap<String, List<String>>();
        }
        if ((headerList = this.addedHeaders.get(name)) == null && create) {
            headerList = new ArrayList<String>();
            this.addedHeaders.put(name, headerList);
        }
        return headerList;
    }

    protected List<String> getSetHeaderList(String name, boolean create) {
        List<String> headerList;
        if (this.setHeaders == null) {
            this.setHeaders = new HashMap<String, List<String>>();
        }
        if ((headerList = this.setHeaders.get(name)) == null && create) {
            headerList = new ArrayList<String>();
            this.setHeaders.put(name, headerList);
        }
        return headerList;
    }

    protected void failIfCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
    }

    public boolean isActionResponse() {
        return this.isActionResponse;
    }

    public boolean isRenderResponse() {
        return this.isRenderResponse;
    }

    public boolean isResourceResponse() {
        return this.isResourceResponse;
    }

    public boolean isMimeResponse() {
        return this.isMimeResponse;
    }

    public boolean isStateAwareResponse() {
        return this.isStateAwareResponse;
    }

    public void addCookie(Cookie cookie) {
        if (!this.committed) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, this.formatDateHeaderValue(date));
    }

    public void addHeader(String name, String value) {
        if (this.isMimeResponse && !this.committed) {
            this.getAddedHeaderList(name, true).add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.isMimeResponse && (this.getAddedHeaderList(name, false) != null || this.getSetHeaderList(name, false) != null);
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.failIfCommitted();
        this.committed = true;
        this.closed = true;
        this.hasError = true;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void sendError(int errorCode) throws IOException {
        this.sendError(errorCode, null);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        if (this.isActionResponse || this.isMimeResponse) {
            this.failIfCommitted();
            this.closed = true;
            this.committed = true;
            this.redirectLocation = redirectLocation;
        }
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void forward(String pathInfo) throws IOException {
        if (this.isRenderResponse) {
            if (this.response instanceof HstResponse) {
                ((HstResponse)this.response).forward(pathInfo);
            } else {
                this.failIfCommitted();
                this.closed = true;
                this.committed = true;
                this.forwardPathInfo = pathInfo;
            }
        }
    }

    public String getForwardPathInfo() {
        return this.forwardPathInfo;
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.formatDateHeaderValue(date));
    }

    public void setHeader(String name, String value) {
        if (this.isMimeResponse && !this.committed) {
            List<String> headerList = this.getSetHeaderList(name, true);
            headerList.clear();
            headerList.add(value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int statusCode, String message) {
        throw new UnsupportedOperationException("This method is deprecated and no longer supported");
    }

    public void setStatus(int statusCode) {
        if (!this.committed) {
            if (this.response instanceof HstResponse) {
                ((HstResponse)this.response).setStatus(statusCode);
            } else {
                this.statusCode = statusCode;
                this.hasStatus = true;
                this.resetBuffer();
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isMimeResponse && !this.closed) {
            this.committed = true;
        }
    }

    public int getBufferSize() {
        return this.isMimeResponse ? Integer.MAX_VALUE : 0;
    }

    public String getCharacterEncoding() {
        return this.isMimeResponse ? (this.characterEncoding != null ? this.characterEncoding : "ISO-8859-1") : null;
    }

    public String getContentType() {
        return this.isMimeResponse ? this.contentType : null;
    }

    public Locale getLocale() {
        return this.isMimeResponse ? (this.locale != null ? this.locale : this.defaultLocale) : null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.outputStream == null) {
            if (this.printWriter != null) {
                throw new IllegalStateException("getWriter() has already been called on this response");
            }
            this.byteOutputBuffer = new ByteArrayOutputStream();
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    if (!HstServletResponseState.this.closed) {
                        HstServletResponseState.this.byteOutputBuffer.write(b);
                        if (HstServletResponseState.this.contentLength > -1 && HstServletResponseState.this.byteOutputBuffer.size() >= HstServletResponseState.this.contentLength) {
                            HstServletResponseState.this.committed = true;
                            HstServletResponseState.this.closed = true;
                        }
                    }
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.printWriter == null) {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response");
            }
            this.charOutputBuffer = new CharArrayWriterBuffer();
            this.printWriter = new PrintWriter(this.charOutputBuffer);
        }
        return this.printWriter;
    }

    public boolean isCommitted() {
        return this.isMimeResponse && this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.addedHeaders = null;
        this.setHeaders = null;
        this.cookies = null;
        this.hasStatus = false;
        this.contentLength = -1;
        if (this.printWriter == null) {
            this.contentType = null;
            this.characterEncoding = null;
            this.locale = null;
        }
    }

    public void resetBuffer() {
        this.failIfCommitted();
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.byteOutputBuffer.reset();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
            this.charOutputBuffer.reset();
        }
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String charset) {
        if (this.isResourceResponse && charset != null && !this.committed && this.printWriter == null) {
            this.characterEncoding = charset;
            this.setContentTypeAfterEncoding = false;
        }
    }

    public void setContentLength(int len) {
        if (this.isResourceResponse && !this.committed && this.printWriter == null && len > 0) {
            this.contentLength = len;
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.closed && this.byteOutputBuffer != null && this.byteOutputBuffer.size() >= len) {
                this.committed = true;
                this.closed = true;
            }
        }
    }

    public void setContentType(String type) {
        if (this.isMimeResponse && !this.committed) {
            this.contentType = type;
            this.setContentTypeAfterEncoding = false;
            if (this.printWriter == null) {
                // empty if block
            }
        }
    }

    public void setLocale(Locale locale) {
        if (this.isResourceResponse && !this.committed) {
            this.locale = locale;
        }
    }

    public void addHeadElement(Element element, String keyHint) {
        if (this.isMimeResponse && !this.committed) {
            if (this.response instanceof HstResponse) {
                ((HstResponse)this.response).addHeadElement(element, keyHint);
            } else {
                if (this.headElements == null) {
                    this.headElements = new ArrayList<KeyValue<String, Element>>();
                }
                if (element == null) {
                    if (keyHint != null) {
                        DefaultKeyValue<String, Object> kvPair = new DefaultKeyValue<String, Object>(keyHint, null, true);
                        this.headElements.remove(kvPair);
                    } else {
                        this.headElements.clear();
                    }
                    return;
                }
                DefaultKeyValue<String, Element> kvPair = new DefaultKeyValue<String, Element>(keyHint, element, true);
                if (!this.headElements.contains(kvPair)) {
                    this.headElements.add(kvPair);
                }
            }
        }
    }

    public boolean containsHeadElement(String keyHint) {
        boolean containing = false;
        if (this.headElements != null && keyHint != null) {
            DefaultKeyValue<String, Object> kvPair = new DefaultKeyValue<String, Object>(keyHint, null, true);
            containing = this.headElements.contains(kvPair);
        }
        return containing;
    }

    public List<Element> getHeadElements() {
        LinkedList<Element> elements = new LinkedList<Element>();
        if (this.headElements != null) {
            for (KeyValue<String, Element> kv : this.headElements) {
                elements.add((Element)kv.getValue());
            }
        }
        return elements;
    }

    public void addPreambleNode(Comment comment) {
        if (this.preambleComments == null) {
            this.preambleComments = new ArrayList<Comment>();
        }
        this.preambleComments.add(comment);
    }

    public void addPreambleNode(Element element) {
        if (this.preambleElements == null) {
            this.preambleElements = new ArrayList<Element>();
        }
        this.preambleElements.add(element);
    }

    public void setWrapperElement(Element element) {
        this.wrapperElement = element;
    }

    public Element getWrapperElement() {
        return this.wrapperElement;
    }

    public void clear() {
        this.printWriter = null;
        this.byteOutputBuffer = null;
        this.charOutputBuffer = null;
        this.outputStream = null;
        this.printWriter = null;
        this.addedHeaders = null;
        this.setHeaders = null;
        this.cookies = null;
        this.committed = false;
        this.hasStatus = false;
        this.hasError = false;
        this.locale = null;
        this.setContentTypeAfterEncoding = false;
        this.closed = false;
        this.characterEncoding = null;
        this.contentLength = -1;
        this.contentType = null;
        this.errorCode = 0;
        this.errorMessage = null;
        this.statusCode = 0;
        this.redirectLocation = null;
    }

    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.flushed = true;
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                this.addResponseCookie(cookie);
            }
            this.cookies = null;
        }
        if (this.isMimeResponse) {
            if (this.locale != null) {
                try {
                    this.setResponseLocale(this.locale);
                }
                catch (UnsupportedOperationException usoe) {
                    // empty catch block
                }
            }
            if (this.contentType != null) {
                if (this.characterEncoding != null) {
                    if (this.setContentTypeAfterEncoding) {
                        this.setResponseCharacterEncoding(this.characterEncoding);
                        this.setResponseContentType(this.contentType);
                    } else {
                        this.setResponseContentType(this.contentType);
                        this.setResponseCharacterEncoding(this.characterEncoding);
                    }
                } else {
                    this.setResponseContentType(this.contentType);
                }
            } else if (this.characterEncoding != null) {
                this.setResponseCharacterEncoding(this.characterEncoding);
            }
            if (this.addedHeaders != null) {
                for (Map.Entry entry : this.addedHeaders.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        this.addResponseHeader((String)entry.getKey(), value);
                    }
                }
                this.addedHeaders = null;
            }
            if (this.setHeaders != null) {
                for (Map.Entry entry : this.setHeaders.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        this.setResponseHeader((String)entry.getKey(), value);
                    }
                }
                this.setHeaders = null;
            }
            if (this.hasStatus) {
                this.setResponseStatus(this.statusCode);
            }
            if (this.isResourceResponse && this.contentLength > -1) {
                try {
                    this.setResponseContentLength(this.contentLength);
                }
                catch (UnsupportedOperationException usoe) {
                    // empty catch block
                }
            }
            if (this.headElements != null) {
                for (KeyValue keyValue : this.headElements) {
                    this.addResponseHeadElement((Element)keyValue.getValue(), (String)keyValue.getKey());
                }
                this.headElements = null;
            }
            if (!this.hasError && this.redirectLocation == null) {
                if (this.outputStream != null) {
                    int n;
                    if (!this.closed) {
                        this.outputStream.flush();
                    }
                    OutputStream realOutputStream = this.getResponseOutputStream();
                    int n2 = this.byteOutputBuffer.size();
                    if (this.contentLength > -1 && this.contentLength < n2) {
                        n = this.contentLength;
                    }
                    this.printPreambleComments(this.preambleComments, realOutputStream);
                    this.printPreambleElements(this.preambleElements, realOutputStream, n);
                    if (this.wrapperElement == null) {
                        if (n > 0) {
                            realOutputStream.write(this.byteOutputBuffer.toByteArray(), 0, n);
                        }
                    } else {
                        WrapperElementImpl wrapperElem = new WrapperElementImpl(this.wrapperElement);
                        WrapperElementUtils.writeWrapperElement(realOutputStream, this.characterEncoding, wrapperElem, this.byteOutputBuffer.toByteArray(), 0, n);
                    }
                    this.outputStream.close();
                    this.outputStream = null;
                    this.byteOutputBuffer = null;
                } else if (this.printWriter != null) {
                    if (!this.closed) {
                        this.printWriter.flush();
                        this.printPreambleComments(this.preambleComments, null);
                        this.printPreambleElements(this.preambleElements, null, 0);
                        if (this.wrapperElement == null) {
                            if (this.charOutputBuffer.getCount() > 0) {
                                this.getResponseWriter().write(this.charOutputBuffer.getBuffer(), 0, this.charOutputBuffer.getCount());
                            }
                        } else {
                            WrapperElementImpl wrapperElem = new WrapperElementImpl(this.wrapperElement);
                            WrapperElementUtils.writeWrapperElement(this.getResponseWriter(), wrapperElem, this.charOutputBuffer.getBuffer(), 0, this.charOutputBuffer.getCount());
                        }
                        this.printWriter.close();
                        this.printWriter = null;
                        this.charOutputBuffer = null;
                    }
                } else if (!this.closed) {
                    this.printPreambleComments(this.preambleComments, null);
                    this.printPreambleElements(this.preambleElements, null, 0);
                }
            }
        }
    }

    private void printPreambleComments(List<Comment> preambles, OutputStream outputStream) throws IOException {
        block4: {
            if (preambles == null) break block4;
            if (outputStream == null) {
                for (Comment comment : preambles) {
                    this.getResponseWriter().write("<!-- " + comment.getTextContent() + " -->");
                }
            } else {
                OutputStreamWriter writer = this.characterEncoding != null ? new OutputStreamWriter(outputStream, this.characterEncoding) : new OutputStreamWriter(outputStream);
                for (Comment comment : preambles) {
                    writer.write("<!-- " + comment.getTextContent() + " -->");
                }
            }
        }
    }

    private void printPreambleElements(List<Element> preambles, OutputStream outputStream, int contentLength) throws IOException {
        block4: {
            if (preambles == null) break block4;
            if (outputStream == null) {
                for (Element element : preambles) {
                    WrapperElementImpl wrapperElem = new WrapperElementImpl(element);
                    WrapperElementUtils.writeWrapperElement(this.getResponseWriter(), wrapperElem, null, 0, 0);
                }
            } else {
                OutputStreamWriter writer = this.characterEncoding != null ? new OutputStreamWriter(outputStream, this.characterEncoding) : new OutputStreamWriter(outputStream);
                for (Element element : preambles) {
                    WrapperElementImpl wrapperElem = new WrapperElementImpl(element);
                    WrapperElementUtils.writeWrapperElement(outputStream, this.characterEncoding, wrapperElem, this.byteOutputBuffer.toByteArray(), 0, contentLength);
                }
            }
        }
    }

    public Comment createComment(String comment) {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            return doc.createComment(comment);
        }
        catch (ParserConfigurationException e) {
            throw new DOMException(0, "Initialization failure");
        }
    }

    protected void setResponseLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    protected void addResponseCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    protected void setResponseCharacterEncoding(String characterEncoding) {
        this.response.setCharacterEncoding(characterEncoding);
    }

    protected void setResponseContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    protected void addResponseHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    protected void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    protected void addResponseHeadElement(Element element, String keyHint) {
        if (this.response instanceof HstResponse) {
            ((HstResponse)this.response).addHeadElement(element, keyHint);
        }
    }

    protected void setResponseStatus(int status) {
        this.response.setStatus(status);
    }

    protected void setResponseContentLength(int len) {
        this.response.setContentLength(len);
    }

    protected OutputStream getResponseOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    protected PrintWriter getResponseWriter() throws IOException {
        return this.response.getWriter();
    }

    private String formatDateHeaderValue(long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date(date));
    }

    private static class CharArrayWriterBuffer
    extends CharArrayWriter {
        private CharArrayWriterBuffer() {
        }

        private char[] getBuffer() {
            return this.buf;
        }

        private int getCount() {
            return this.count;
        }
    }
}

