/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.core.component.HstParameterInfoProxyFactory;
import org.hippoecm.hst.core.component.HstParameterValueConversionException;
import org.hippoecm.hst.core.component.HstParameterValueConverter;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.parameters.EmptyPropertyEditor;
import org.hippoecm.hst.core.parameters.Parameter;
import org.hippoecm.hst.core.parameters.ParametersInfo;
import org.hippoecm.hst.core.request.ComponentConfiguration;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;

public class HstParameterInfoProxyFactoryImpl
implements HstParameterInfoProxyFactory {
    private static final String LOGGER_NAME = HstParameterInfoProxyFactoryImpl.class.getName();

    public <T> T createParameterInfoProxy(ParametersInfo parametersInfo, ComponentConfiguration componentConfig, HstRequest request, HstParameterValueConverter converter) {
        Class parametersInfoType = parametersInfo.type();
        if (!parametersInfoType.isInterface()) {
            throw new IllegalArgumentException("The ParametersInfo annotation type must be an interface.");
        }
        InvocationHandler parameterInfoHandler = this.createHstParameterInfoInvocationHandler(componentConfig, request, converter);
        Object parametersInfoInterface = Proxy.newProxyInstance(parametersInfoType.getClassLoader(), new Class[]{parametersInfoType}, parameterInfoHandler);
        return (T)parametersInfoInterface;
    }

    protected InvocationHandler createHstParameterInfoInvocationHandler(ComponentConfiguration componentConfig, HstRequest request, HstParameterValueConverter converter) {
        return new ParameterInfoInvocationHandler(componentConfig, request, converter);
    }

    private static final boolean isGetter(Method method, Object[] args) {
        if (args == null || args.length == 0) {
            String methodName = method.getName();
            return methodName.startsWith("get") || methodName.startsWith("is");
        }
        return false;
    }

    private static final boolean isSetter(Method method, Object[] args) {
        return args != null && args.length == 1 && method.getName().startsWith("set");
    }

    protected static class ParameterInfoInvocationHandler
    implements InvocationHandler {
        private final ComponentConfiguration componentConfig;
        private final HstRequest request;
        private final HstParameterValueConverter converter;

        public ParameterInfoInvocationHandler(ComponentConfiguration componentConfig, HstRequest request, HstParameterValueConverter converter) {
            this.componentConfig = componentConfig;
            this.request = request;
            this.converter = converter;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            Logger log = HstServices.getLogger(LOGGER_NAME);
            if (HstParameterInfoProxyFactoryImpl.isSetter(method, args)) {
                throw new UnsupportedOperationException("Setter method (" + method.getName() + ") is not supported.");
            }
            if (!HstParameterInfoProxyFactoryImpl.isGetter(method, args)) {
                return null;
            }
            Parameter parameterAnnotation = method.getAnnotation(Parameter.class);
            if (parameterAnnotation == null) {
                throw new IllegalArgumentException("Component " + this.componentConfig.getCanonicalPath() + " uses ParametersInfo annotation, but " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + " is not annotated with " + Parameter.class.getName());
            }
            String parameterName = parameterAnnotation.name();
            if (parameterName == null || "".equals(parameterName)) {
                throw new IllegalArgumentException("The parameter name is empty.");
            }
            String parameterValue = this.getParameterValue(parameterName, this.componentConfig, this.request);
            String defaultValue = null;
            if (parameterValue == null || "".equals(parameterValue)) {
                parameterValue = defaultValue = parameterAnnotation.defaultValue();
            }
            if (parameterValue == null) {
                return null;
            }
            Class customEditorType = parameterAnnotation.customEditor();
            Class<?> returnType = method.getReturnType();
            if (customEditorType == null || customEditorType == EmptyPropertyEditor.class) {
                try {
                    return this.converter.convert(parameterValue, returnType);
                }
                catch (HstParameterValueConversionException e) {
                    log.warn("Could not convert '" + parameterValue + "' to returnType " + returnType.getName() + ".. Try to return default value", (Object)e.toString());
                    if (defaultValue == null) {
                        log.warn("Could not convert '" + parameterValue + "' to returnType " + returnType.getName() + " and there is no default value configured");
                        return null;
                    }
                    return this.converter.convert(defaultValue, returnType);
                }
            }
            PropertyEditor customEditor = (PropertyEditor)customEditorType.newInstance();
            customEditor.setAsText(parameterValue);
            return customEditor.getValue();
        }

        private String getParameterValue(String parameterName, ComponentConfiguration config, HstRequest req) {
            String prefixedParameterName = this.getPrefixedParameterName(parameterName, config, req);
            String parameterValue = config.getParameter(prefixedParameterName, req.getRequestContext().getResolvedSiteMapItem());
            if (parameterValue == null && !parameterName.equals(prefixedParameterName)) {
                parameterValue = config.getParameter(parameterName, req.getRequestContext().getResolvedSiteMapItem());
            }
            return parameterValue;
        }

        protected String getPrefixedParameterName(String parameterName, ComponentConfiguration config, HstRequest req) {
            HttpSession session = req.getSession(false);
            if (session != null && session.getAttribute("org.hippoecm.hst.container.render_variant") != null) {
                String prefix = session.getAttribute("org.hippoecm.hst.container.render_variant").toString();
                if ("hippo-default".equals(prefix)) {
                    return parameterName;
                }
                String prefixedParameterName = prefix + '\uffff' + parameterName;
                if (config.getParameterNames().contains(prefixedParameterName)) {
                    return prefixedParameterName;
                }
            }
            return parameterName;
        }
    }
}

