/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.internal.ContextualizableMount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.model.MutableHstManager;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.container.HstContainerConfigImpl;
import org.hippoecm.hst.container.HstContainerRequest;
import org.hippoecm.hst.container.HstContainerRequestImpl;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.ResourceLifecycleManagement;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ContainerNotFoundException;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.internal.HstRequestContextComponent;
import org.hippoecm.hst.core.internal.MountDecorator;
import org.hippoecm.hst.core.internal.MutableResolvedMount;
import org.hippoecm.hst.core.jcr.pool.MultipleRepository;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.core.sitemapitemhandler.FilterChainAwareHstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerException;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerFactory;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.logging.Logger;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.GenericHttpServletRequestWrapper;
import org.hippoecm.hst.util.HstRequestUtils;
import org.hippoecm.hst.util.ServletConfigUtils;

public class HstFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private static final String LOGGER_CATEGORY_NAME = HstFilter.class.getName();
    private static final String FILTER_DONE_KEY = "filter.done_" + HstFilter.class.getName();
    private static final String PATH_PREFIX_UUID_REDIRECT = "/previewfromcms";
    private static final String REQUEST_PARAM_UUID = "uuid";
    private static final String REQUEST_PARAM_TYPE = "type";
    private static final String DEFAULT_REQUEST_PARAM_TYPE = "live";
    private FilterConfig filterConfig;
    public static final String CONTEXT_NAMESPACE_INIT_PARAM = "hstContextNamespace";
    public static final String CLIENT_REDIRECT_AFTER_JAAS_LOGIN_BEHIND_PROXY = "clientRedirectAfterJaasLoginBehindProxy";
    public static final String CLIENT_COMPONENT_MANAGER_CLASS_INIT_PARAM = "clientComponentManagerClass";
    public static final String CLIENT_COMPONENT_MANAGER_CONFIGURATIONS_INIT_PARAM = "clientComponentManagerConfigurations";
    public static final String CLIENT_COMPONENT_MANAGER_CONTEXT_ATTRIBUTE_NAME_INIT_PARAM = "clientComponentManagerContextAttributeName";
    public static final String CLIENT_COMPONENT_MANANGER_DEFAULT_CONTEXT_ATTRIBUTE_NAME = HstFilter.class.getName() + ".clientComponentManager";
    public static final String PREFIX_EXCLUSIONS_INIT_PARAM = "prefixExclusions";
    public static final String SUFFIX_EXCLUSIONS_INIT_PARAM = "suffixExclusions";
    private static final String DEFAULT_LOGIN_RESOURCE_PATH = "/login/resource";
    protected String contextNamespace;
    protected boolean doClientRedirectAfterJaasLoginBehindProxy;
    protected String clientComponentManagerClassName;
    protected String[] clientComponentManagerConfigurations;
    protected volatile boolean initialized;
    protected ComponentManager clientComponentManager;
    protected String clientComponentManagerContextAttributeName = CLIENT_COMPONENT_MANANGER_DEFAULT_CONTEXT_ATTRIBUTE_NAME;
    protected volatile HstContainerConfig requestContainerConfig;
    protected HstManager currentManagerInstance;
    private String[] prefixExclusions;
    private String[] suffixExclusions;
    private String defaultLoginResourcePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.contextNamespace = this.getConfigOrContextInitParameter(CONTEXT_NAMESPACE_INIT_PARAM, this.contextNamespace);
        this.doClientRedirectAfterJaasLoginBehindProxy = Boolean.parseBoolean(this.getConfigOrContextInitParameter(CLIENT_REDIRECT_AFTER_JAAS_LOGIN_BEHIND_PROXY, "true"));
        this.clientComponentManagerClassName = this.getConfigOrContextInitParameter(CLIENT_COMPONENT_MANAGER_CLASS_INIT_PARAM, this.clientComponentManagerClassName);
        this.clientComponentManagerConfigurations = HstFilter.splitParamValue(this.getConfigOrContextInitParameter(CLIENT_COMPONENT_MANAGER_CONFIGURATIONS_INIT_PARAM, null), ",");
        this.clientComponentManagerContextAttributeName = this.getConfigOrContextInitParameter(CLIENT_COMPONENT_MANAGER_CONTEXT_ATTRIBUTE_NAME_INIT_PARAM, this.clientComponentManagerContextAttributeName);
        this.defaultLoginResourcePath = HstFilter.getInitParameter(filterConfig, null, "loginResource", DEFAULT_LOGIN_RESOURCE_PATH);
        this.prefixExclusions = HstFilter.splitParamValue(this.getConfigOrContextInitParameter(PREFIX_EXCLUSIONS_INIT_PARAM, null), ",");
        this.suffixExclusions = HstFilter.splitParamValue(this.getConfigOrContextInitParameter(SUFFIX_EXCLUSIONS_INIT_PARAM, null), ",");
        this.initialized = false;
        if (HstServices.isAvailable()) {
            HstFilter hstFilter = this;
            synchronized (hstFilter) {
                this.doInit(filterConfig);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit(FilterConfig config) {
        if (this.clientComponentManager != null) {
            try {
                this.clientComponentManager.stop();
                this.clientComponentManager.close();
            }
            catch (Exception e) {
            }
            finally {
                this.clientComponentManager = null;
            }
        }
        try {
            if (this.clientComponentManagerClassName != null && this.clientComponentManagerConfigurations != null && this.clientComponentManagerConfigurations.length > 0) {
                this.clientComponentManager = (ComponentManager)Thread.currentThread().getContextClassLoader().loadClass(this.clientComponentManagerClassName).newInstance();
                this.clientComponentManager.setServletContext(config.getServletContext());
                this.clientComponentManager.setConfigurationResources(this.clientComponentManagerConfigurations);
                this.clientComponentManager.initialize();
                this.clientComponentManager.start();
                config.getServletContext().setAttribute(this.clientComponentManagerContextAttributeName, (Object)this.clientComponentManager);
            }
        }
        catch (Exception e) {
            this.log("Invalid client component manager class or configuration: " + e);
        }
    }

    public static ComponentManager getClientComponentManager(ServletContext servletContext) {
        String attributeName = ServletConfigUtils.getInitParameter(null, servletContext, CLIENT_COMPONENT_MANAGER_CONTEXT_ATTRIBUTE_NAME_INIT_PARAM, CLIENT_COMPONENT_MANANGER_DEFAULT_CONTEXT_ATTRIBUTE_NAME);
        return (ComponentManager)servletContext.getAttribute(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute("org.hippoecm.hst.container.HstFilter.reset") != null) {
            request.removeAttribute(FILTER_DONE_KEY);
            request.removeAttribute("org.hippoecm.hst.container.HstFilter.reset");
        }
        if (request.getAttribute(FILTER_DONE_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        request.setAttribute(FILTER_DONE_KEY, (Object)Boolean.TRUE);
        Logger logger = HstServices.getLogger(LOGGER_CATEGORY_NAME);
        boolean requestContextSetToProvider = false;
        Task rootTask = null;
        try {
            String requestURI;
            String referer;
            ResolvedVirtualHost resolvedVirtualHost;
            HstContainerRequestImpl containerRequest;
            HstSiteMapItemHandlerFactory siteMapItemHandlerFactory;
            HstManager hstManager;
            if (!HstServices.isAvailable()) {
                res.sendError(503);
                logger.error("The HST Container Services are not initialized yet.");
                return;
            }
            if (!this.initialized) {
                HstFilter hstFilter = this;
                synchronized (hstFilter) {
                    if (!this.initialized) {
                        this.doInit(this.filterConfig);
                        this.initialized = true;
                    }
                }
            }
            if ((hstManager = this.getHstManager()) != this.currentManagerInstance) {
                HstFilter hstFilter = this;
                synchronized (hstFilter) {
                    this.currentManagerInstance = hstManager;
                    if (hstManager instanceof MutableHstManager) {
                        ((MutableHstManager)hstManager).setHstFilterPrefixExclusions(this.prefixExclusions);
                        ((MutableHstManager)hstManager).setHstFilterSuffixExclusions(this.suffixExclusions);
                    }
                }
            }
            if ((siteMapItemHandlerFactory = hstManager.getSiteMapItemHandlerFactory()) == null || hstManager == null) {
                res.sendError(503);
                logger.error("The HstManager or siteMapItemHandlerFactory is not available");
                return;
            }
            if (this.requestContainerConfig == null) {
                HstFilter hstFilter = this;
                synchronized (hstFilter) {
                    if (this.requestContainerConfig == null) {
                        this.requestContainerConfig = new HstContainerConfigImpl(this.filterConfig.getServletContext(), Thread.currentThread().getContextClassLoader());
                    }
                }
            }
            if ((containerRequest = new HstContainerRequestImpl(req, hstManager.getPathSuffixDelimiter())).getPathSuffix() == null && hstManager.isExcludedByHstFilterInitParameter(containerRequest.getPathInfo())) {
                chain.doFilter(request, response);
                return;
            }
            VirtualHosts vHosts = hstManager.getVirtualHosts(this.isStaleConfigurationAllowedForRequest((HttpServletRequest)containerRequest));
            String hostName = HstRequestUtils.getFarthestRequestHost((HttpServletRequest)containerRequest);
            String ip = HstRequestUtils.getFarthestRemoteAddr((HttpServletRequest)containerRequest);
            if (vHosts.isDiagnosticsEnabled(ip)) {
                rootTask = HDC.start(HstFilter.class.getSimpleName());
                rootTask.setAttribute("hostName", (Object)hostName);
                rootTask.setAttribute("uri", (Object)req.getRequestURI());
                rootTask.setAttribute("query", (Object)req.getQueryString());
            }
            if ((resolvedVirtualHost = vHosts.matchVirtualHost(hostName)) == null) {
                logger.warn("hostName '{}' can not be matched. Skip HST Filter and request processing. ", (Object)hostName);
                chain.doFilter(request, response);
                return;
            }
            if (this.doClientRedirectAfterJaasLoginBehindProxy && !resolvedVirtualHost.getVirtualHost().isContextPathInUrl() && !"".equals(req.getContextPath()) && (referer = req.getHeader("Referer")) != null && referer.endsWith(this.defaultLoginResourcePath) && (requestURI = req.getRequestURI()).startsWith(req.getContextPath() + req.getContextPath() + "/")) {
                String redirectTo = requestURI.substring((req.getContextPath() + req.getContextPath()).length());
                res.sendRedirect(redirectTo);
                return;
            }
            request.setAttribute("org.hippoecm.hst.configuration.hosting.VirtualHost.requestAttr", (Object)resolvedVirtualHost);
            if (vHosts == null || containerRequest.getPathSuffix() == null && vHosts.isExcluded(containerRequest.getPathInfo())) {
                chain.doFilter(request, response);
                return;
            }
            HstMutableRequestContext requestContext = (HstMutableRequestContext)containerRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
            if (requestContext == null) {
                HstRequestContextComponent rcc = (HstRequestContextComponent)HstServices.getComponentManager().getComponent(HstRequestContextComponent.class.getName());
                requestContext = rcc.create();
                if (this.contextNamespace != null) {
                    requestContext.setContextNamespace(this.contextNamespace);
                }
                containerRequest.setAttribute("org.hippoecm.hst.core.request.HstRequestContext", requestContext);
            }
            requestContext.setServletContext(this.filterConfig.getServletContext());
            requestContext.setPathSuffix(containerRequest.getPathSuffix());
            if ("true".equals(request.getParameter("org.hippoecm.hst.container.request.fqu"))) {
                requestContext.setFullyQualifiedURLs(true);
            }
            RequestContextProvider.set((HstRequestContext)requestContext);
            requestContextSetToProvider = true;
            if (containerRequest.getPathInfo().startsWith(PATH_PREFIX_UUID_REDIRECT)) {
                this.sendRedirectToUuidUrl(req, res, requestContext, hstManager, resolvedVirtualHost, containerRequest, hostName, logger);
                return;
            }
            ResolvedMount resolvedMount = requestContext.getResolvedMount();
            if (resolvedMount == null) {
                resolvedMount = vHosts.matchMount(hostName, containerRequest.getContextPath(), containerRequest.getPathInfo());
                if (resolvedMount == null) throw new MatchException("No matching Mount for '" + hostName + "' and '" + containerRequest.getRequestURI() + "'");
                requestContext.setResolvedMount(resolvedMount);
                String renderingHost = HstRequestUtils.getRenderingHost((HttpServletRequest)containerRequest);
                if (renderingHost != null) {
                    requestContext.setRenderHost(renderingHost);
                    HttpSession session = containerRequest.getSession(false);
                    if (this.requestComesFromCms(vHosts, resolvedMount) && session != null && Boolean.TRUE.equals(session.getAttribute("org.hippoecm.hst.container.sso_cms_authenticated"))) {
                        requestContext.setCmsRequest(true);
                        req.setAttribute("org.hippoecm.hst.container.request_comes_from_cms", (Object)Boolean.TRUE);
                        session.setAttribute("org.hippoecm.hst.container.render_host", (Object)renderingHost);
                        if (!(resolvedMount instanceof MutableResolvedMount)) throw new MatchException("ResolvedMount must be an instance of MutableResolvedMount to be usable in CMS SSO environment. Cannot proceed request for " + hostName + " and " + containerRequest.getRequestURI());
                        Mount mount = resolvedMount.getMount();
                        if (!(mount instanceof ContextualizableMount)) {
                            throw new MatchException("The matched mount for request '" + hostName + " and " + containerRequest.getRequestURI() + "' is not an instanceof of a ContextualizableMount. Cannot act as preview mount. Cannot proceed request for CMS SSO environment.");
                        }
                        MountDecorator mountDecorator = (MountDecorator)HstServices.getComponentManager().getComponent(MountDecorator.class.getName());
                        ContextualizableMount decoratedMount = mountDecorator.decorateMountAsPreview((ContextualizableMount)mount);
                        if (decoratedMount == mount) {
                            logger.debug("Matched mount pointing to site '{}' is already a preview so no need for CMS SSO context to decorate the mount to a preview", (Object)mount.getMountPoint());
                        } else {
                            logger.debug("Matched mount pointing to site '{}' is because of CMS SSO context replaced by preview decorated mount pointing to site '{}'", (Object)mount.getMountPoint(), (Object)decoratedMount.getMountPoint());
                        }
                        ((MutableResolvedMount)resolvedMount).setMount((Mount)decoratedMount);
                    }
                }
            }
            HstContainerURL hstContainerUrl = this.setMountPathAsServletPath(containerRequest, hstManager, requestContext, resolvedMount, res);
            if (resolvedMount.getMount().isMapped()) {
                ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
                boolean processSiteMapItemHandlers = false;
                if (resolvedSiteMapItem == null) {
                    processSiteMapItemHandlers = true;
                    resolvedSiteMapItem = resolvedMount.matchSiteMapItem(hstContainerUrl.getPathInfo());
                    if (resolvedSiteMapItem == null) {
                        logger.warn(hostName + "' and '" + containerRequest.getRequestURI() + "' could not be processed by the HST: Error resolving request to sitemap item");
                        HstFilter.sendError(req, res, 404);
                        return;
                    }
                    requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
                }
                HstSiteMapItem hstSiteMapItem = resolvedSiteMapItem.getHstSiteMapItem();
                if (!(requestContext.isCmsRequest() || hstSiteMapItem.isSchemeAgnostic() || hstSiteMapItem.getScheme().equals(HstRequestUtils.getFarthestRequestScheme(req)))) {
                    switch (hstSiteMapItem.getSchemeNotMatchingResponseCode()) {
                        case 200: {
                            break;
                        }
                        case 301: {
                            res.setStatus(301);
                            res.setHeader("Location", HstRequestUtils.createURLWithExplicitSchemeForRequest(hstSiteMapItem.getScheme(), resolvedSiteMapItem.getResolvedMount().getMount(), req));
                            return;
                        }
                        case 302: 
                        case 303: 
                        case 307: {
                            res.sendRedirect(HstRequestUtils.createURLWithExplicitSchemeForRequest(hstSiteMapItem.getScheme(), resolvedSiteMapItem.getResolvedMount().getMount(), req));
                            return;
                        }
                        case 404: {
                            HstFilter.sendError(req, res, 404);
                            return;
                        }
                        case 403: {
                            HstFilter.sendError(req, res, 403);
                            return;
                        }
                        default: {
                            logger.warn("Unsupported 'schemenotmatchingresponsecode' {} encountered. Continue rendering.", (Object)hstSiteMapItem.getSchemeNotMatchingResponseCode());
                        }
                    }
                }
                this.processResolvedSiteMapItem((HttpServletRequest)containerRequest, res, chain, hstManager, siteMapItemHandlerFactory, requestContext, processSiteMapItemHandlers, logger);
                return;
            } else if (resolvedMount.getNamedPipeline() == null) {
                logger.warn(hostName + "' and '" + containerRequest.getRequestURI() + "' could not be processed by the HST: No hstSite and no custom namedPipeline for Mount");
                HstFilter.sendError(req, res, 404);
                return;
            } else {
                Mount mount = resolvedMount.getMount();
                if (!(requestContext.isCmsRequest() || mount.isSchemeAgnostic() || mount.getScheme().equals(HstRequestUtils.getFarthestRequestScheme(req)))) {
                    switch (mount.getSchemeNotMatchingResponseCode()) {
                        case 200: {
                            break;
                        }
                        case 301: {
                            res.setStatus(301);
                            res.setHeader("Location", HstRequestUtils.createURLWithExplicitSchemeForRequest(mount.getScheme(), mount, req));
                            return;
                        }
                        case 302: 
                        case 303: 
                        case 307: {
                            res.sendRedirect(HstRequestUtils.createURLWithExplicitSchemeForRequest(mount.getScheme(), mount, req));
                            return;
                        }
                        case 404: {
                            HstFilter.sendError(req, res, 404);
                            return;
                        }
                        case 403: {
                            HstFilter.sendError(req, res, 403);
                            return;
                        }
                        default: {
                            logger.warn("Unsupported 'schemenotmatchingresponsecode' {} encountered. Continue rendering.", (Object)mount.getSchemeNotMatchingResponseCode());
                        }
                    }
                }
                logger.info("Processing request for pipeline '{}'", (Object)resolvedMount.getNamedPipeline());
                HstServices.getRequestProcessor().processRequest(this.requestContainerConfig, (HstRequestContext)requestContext, (HttpServletRequest)containerRequest, res, resolvedMount.getNamedPipeline());
            }
            return;
        }
        catch (MatchException e) {
            if (logger.isDebugEnabled()) {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '" + req.getRequestURI() + "':", (Throwable)e);
            } else {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '{}': '{}'", (Object)req.getRequestURI(), (Object)e.toString());
            }
            HstFilter.sendError(req, res, 404);
            return;
        }
        catch (ContainerNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '" + req.getRequestURI() + "':", (Throwable)e);
            } else {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '{}': '{}'", (Object)req.getRequestURI(), (Object)e.toString());
            }
            HstFilter.sendError(req, res, 404);
            return;
        }
        catch (ContainerException e) {
            if (logger.isDebugEnabled()) {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '" + req.getRequestURI() + "':", (Throwable)e);
            } else {
                logger.warn(((Object)((Object)e)).getClass().getName() + " for '{}': '{}'", (Object)req.getRequestURI(), (Object)e.toString());
            }
            HstFilter.sendError(req, res, 500);
            return;
        }
        catch (Exception e) {
            logger.warn("Fatal error encountered while processing request '" + req.getRequestURI() + "':", (Throwable)e);
            HstFilter.sendError(req, res, 500);
            return;
        }
        finally {
            if (requestContextSetToProvider) {
                RequestContextProvider.clear();
            }
            if (rootTask != null) {
                HDC.cleanUp();
            }
        }
    }

    private HstManager getHstManager() {
        return (HstManager)HstServices.getComponentManager().getComponent(HstManager.class.getName());
    }

    private boolean isStaleConfigurationAllowedForRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        return !Boolean.TRUE.equals(session.getAttribute("org.hippoecm.hst.container.sso_cms_authenticated"));
    }

    private boolean requestComesFromCms(VirtualHosts vHosts, ResolvedMount resolvedMount) {
        if (vHosts.getCmsPreviewPrefix() == null || "".equals(vHosts.getCmsPreviewPrefix())) {
            return true;
        }
        return vHosts.getCmsPreviewPrefix().equals(resolvedMount.getMatchingIgnoredPrefix());
    }

    private String getJcrUuidParameter(ServletRequest request, Logger logger) throws IOException {
        String jcrUuid = request.getParameter(REQUEST_PARAM_UUID);
        if (jcrUuid == null || "".equals(jcrUuid)) {
            logger.warn("Cannot redirect when there is no UUID");
            return null;
        }
        try {
            UUID.fromString(jcrUuid);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Cannot redirect because '{}' is not a valid UUID", (Object)jcrUuid);
            return null;
        }
        return jcrUuid;
    }

    private String getTypeParameter(ServletRequest request, Logger logger) {
        String type = request.getParameter(REQUEST_PARAM_TYPE);
        if (type == null) {
            logger.debug("No type defined. Default type is '{}'", (Object)DEFAULT_REQUEST_PARAM_TYPE);
            type = DEFAULT_REQUEST_PARAM_TYPE;
        } else if (!DEFAULT_REQUEST_PARAM_TYPE.equals(type) && !"preview".equals(type)) {
            logger.warn("Ignoring unknown type '{}', using '{}' instead. Known types are 'preview' and 'live'.", (Object)type, (Object)DEFAULT_REQUEST_PARAM_TYPE);
            type = DEFAULT_REQUEST_PARAM_TYPE;
        }
        return type;
    }

    private ResolvedMount getMountForType(HstContainerRequest containerRequest, String type, String hostName, String hostGroupName, VirtualHosts vHosts, String nodePath) {
        List mounts = vHosts.getMountsByHostGroup(hostGroupName);
        if (mounts == null) {
            throw new MatchException("No mounts found for host '" + hostName + "' and '" + containerRequest.getRequestURL() + "'");
        }
        ArrayList<Mount> candidateMounts = new ArrayList<Mount>();
        int bestPathLength = 0;
        for (Mount mount : mounts) {
            if (!mount.isMapped() || !mount.getType().equals(type) || !nodePath.startsWith(mount.getCanonicalContentPath() + "/") && !nodePath.equals(mount.getCanonicalContentPath())) continue;
            if (mount.getCanonicalContentPath().length() == bestPathLength) {
                candidateMounts.add(mount);
                continue;
            }
            if (mount.getCanonicalContentPath().length() <= bestPathLength) continue;
            candidateMounts.clear();
            candidateMounts.add(mount);
            bestPathLength = mount.getCanonicalContentPath().length();
        }
        if (candidateMounts.isEmpty()) {
            throw new MatchException("There is no mount of type '" + type + "' in the host group for '" + hostName + "' and '" + containerRequest.getRequestURL() + "' that can create a link for a document with path '" + nodePath + "'");
        }
        Mount bestMount = (Mount)candidateMounts.get(0);
        int typeCount = Integer.MAX_VALUE;
        for (Mount mount : candidateMounts) {
            if (mount.getTypes().size() >= typeCount) continue;
            typeCount = mount.getTypes().size();
            bestMount = mount;
        }
        return vHosts.matchMount(hostName, containerRequest.getContextPath(), bestMount.getMountPath());
    }

    private HstContainerURL setMountPathAsServletPath(HstContainerRequest containerRequest, HstManager hstSitesManager, HstMutableRequestContext requestContext, ResolvedMount mount, HttpServletResponse response) {
        ((GenericHttpServletRequestWrapper)containerRequest).setServletPath(mount.getResolvedMountPath());
        HstContainerURL hstContainerURL = requestContext.getBaseURL();
        if (hstContainerURL == null) {
            hstContainerURL = hstSitesManager.getUrlFactory().getContainerURLProvider().parseURL((HttpServletRequest)containerRequest, response, mount);
            requestContext.setBaseURL(hstContainerURL);
        }
        return hstContainerURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRedirectToUuidUrl(HttpServletRequest req, HttpServletResponse res, HstMutableRequestContext requestContext, HstManager hstSitesManager, ResolvedVirtualHost resolvedVirtualHost, HstContainerRequest containerRequest, String hostName, Logger logger) throws RepositoryException, IOException {
        String jcrUuid = this.getJcrUuidParameter((ServletRequest)req, logger);
        if (jcrUuid == null) {
            HstFilter.sendError(req, res, 400);
            return;
        }
        Session session = null;
        try {
            Credentials configReaderCreds = (Credentials)HstServices.getComponentManager().getComponent(Credentials.class.getName() + ".hstconfigreader");
            Repository repository = (Repository)HstServices.getComponentManager().getComponent(Repository.class.getName());
            session = repository.login(configReaderCreds);
            Node node = null;
            try {
                node = session.getNodeByIdentifier(jcrUuid);
            }
            catch (ItemNotFoundException e) {
                logger.warn("Cannot find a node for uuid '{}'", (Object)jcrUuid);
                HstFilter.sendError(req, res, 404);
                if (session != null) {
                    session.logout();
                }
                return;
            }
            String mountType = this.getTypeParameter((ServletRequest)req, logger);
            String hostGroupName = resolvedVirtualHost.getVirtualHost().getHostGroupName();
            ResolvedMount mount = this.getMountForType(containerRequest, mountType, hostName, hostGroupName, resolvedVirtualHost.getVirtualHost().getVirtualHosts(), node.getPath());
            if (mount == null) {
                throw new MatchException("No matching mount for '" + hostName + "' and '" + containerRequest.getRequestURL() + "'");
            }
            requestContext.setResolvedMount(mount);
            ((GenericHttpServletRequestWrapper)containerRequest).setRequestURI(mount.getResolvedMountPath() + "/" + PATH_PREFIX_UUID_REDIRECT);
            this.setMountPathAsServletPath(containerRequest, hstSitesManager, requestContext, mount, res);
            HstLinkCreator linkCreator = (HstLinkCreator)HstServices.getComponentManager().getComponent(HstLinkCreator.class.getName());
            if (linkCreator == null) {
                logger.error("Cannot create a 'uuid url' when there is no linkCreator available");
                HstFilter.sendError(req, res, 500);
                return;
            }
            requestContext.setURLFactory(hstSitesManager.getUrlFactory());
            HstLink link = linkCreator.create(node, (HstRequestContext)requestContext);
            if (link == null) {
                logger.warn("Not able to create link for node '{}' belonging to uuid = '{}'", (Object)node.getPath(), (Object)jcrUuid);
                HstFilter.sendError(req, res, 404);
                return;
            }
            String url = link.toUrlForm((HstRequestContext)requestContext, false);
            if (requestContext.isFullyQualifiedURLs()) {
                url = url + "?org.hippoecm.hst.container.request.fqu=true";
            }
            if (logger.isInfoEnabled()) {
                logger.info("Created HstLink for uuid '{}': '{}'", (Object)node.getPath(), (Object)url);
            }
            req.removeAttribute("org.hippoecm.hst.core.request.HstRequestContext");
            res.sendRedirect(url);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static void sendError(HttpServletRequest request, HttpServletResponse response, int errorCode) throws IOException {
        request.removeAttribute("org.hippoecm.hst.core.request.HstRequestContext");
        response.sendError(errorCode);
    }

    public static void cleanupResourceLifecycleManagements() {
        Repository repository = (Repository)HstServices.getComponentManager().getComponent(Repository.class.getName());
        if (repository instanceof MultipleRepository) {
            ResourceLifecycleManagement[] resourceLifecycleManagements;
            for (ResourceLifecycleManagement resourceLifecycleManagement : resourceLifecycleManagements = ((MultipleRepository)repository).getResourceLifecycleManagements()) {
                resourceLifecycleManagement.disposeAllResources();
            }
        }
    }

    public static void initializeResourceLifecycleManagements() {
        Repository repository = (Repository)HstServices.getComponentManager().getComponent(Repository.class.getName());
        if (repository instanceof MultipleRepository) {
            ResourceLifecycleManagement[] resourceLifecycleManagements;
            for (ResourceLifecycleManagement resourceLifecycleManagement : resourceLifecycleManagements = ((MultipleRepository)repository).getResourceLifecycleManagements()) {
                resourceLifecycleManagement.setActive(true);
            }
        }
    }

    protected void processResolvedSiteMapItem(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain, HstManager hstSitesManager, HstSiteMapItemHandlerFactory siteMapItemHandlerFactory, HstMutableRequestContext requestContext, boolean processHandlers, Logger logger) throws ContainerException {
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        if (processHandlers) {
            HstFilter.initializeResourceLifecycleManagements();
            try {
                resolvedSiteMapItem = this.processHandlers(resolvedSiteMapItem, siteMapItemHandlerFactory, req, res, filterChain);
                if (resolvedSiteMapItem == null) {
                    HstFilter.cleanupResourceLifecycleManagements();
                    return;
                }
            }
            catch (HstSiteMapItemHandlerException e) {
                HstFilter.cleanupResourceLifecycleManagements();
                throw e;
            }
            requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
        }
        if (resolvedSiteMapItem.getErrorCode() > 0) {
            block12: {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The resolved sitemap item for {} has error status: {}", (Object)requestContext.getBaseURL().getRequestPath(), (Object)resolvedSiteMapItem.getErrorCode());
                    }
                    res.sendError(resolvedSiteMapItem.getErrorCode());
                }
                catch (IOException e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Exception invocation on sendError().", (Throwable)e);
                    }
                    if (!logger.isWarnEnabled()) break block12;
                    logger.warn("Exception invocation on sendError().");
                }
            }
            return;
        }
        if (resolvedSiteMapItem.getStatusCode() > 0) {
            logger.debug("Setting the status code to '{}' for '{}' because the matched sitemap item has specified the status code", (Object)String.valueOf(resolvedSiteMapItem.getStatusCode()), (Object)req.getRequestURL().toString());
            res.setStatus(resolvedSiteMapItem.getStatusCode());
        }
        HstServices.getRequestProcessor().processRequest(this.requestContainerConfig, (HstRequestContext)requestContext, req, res, resolvedSiteMapItem.getNamedPipeline());
        if (req.getAttribute("org.hippoecm.hst.container.forward.path_info") != null) {
            String forwardPathInfo = (String)req.getAttribute("org.hippoecm.hst.container.forward.path_info");
            req.removeAttribute("org.hippoecm.hst.container.forward.path_info");
            resolvedSiteMapItem = resolvedSiteMapItem.getResolvedMount().matchSiteMapItem(forwardPathInfo);
            if (resolvedSiteMapItem == null) {
                throw new MatchException("Error resolving request to sitemap item: '" + HstRequestUtils.getFarthestRequestHost(req) + "' and '" + req.getRequestURI() + "'");
            }
            requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
            requestContext.setBaseURL(hstSitesManager.getUrlFactory().getContainerURLProvider().createURL(requestContext.getBaseURL(), forwardPathInfo));
            this.processResolvedSiteMapItem(req, res, filterChain, hstSitesManager, siteMapItemHandlerFactory, requestContext, true, logger);
        }
    }

    protected ResolvedSiteMapItem processHandlers(ResolvedSiteMapItem orginalResolvedSiteMapItem, HstSiteMapItemHandlerFactory siteMapItemHandlerFactory, HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        Logger logger = HstServices.getLogger(LOGGER_CATEGORY_NAME);
        ResolvedSiteMapItem newResolvedSiteMapItem = orginalResolvedSiteMapItem;
        List handlerConfigsFromMatchedSiteMapItem = orginalResolvedSiteMapItem.getHstSiteMapItem().getSiteMapItemHandlerConfigurations();
        for (HstSiteMapItemHandlerConfiguration handlerConfig : handlerConfigsFromMatchedSiteMapItem) {
            HstSiteMapItemHandler handler = siteMapItemHandlerFactory.getSiteMapItemHandlerInstance(this.requestContainerConfig, handlerConfig);
            logger.debug("Processing siteMapItemHandler for configuration handler '{}'", (Object)handlerConfig.getName());
            try {
                newResolvedSiteMapItem = handler instanceof FilterChainAwareHstSiteMapItemHandler ? ((FilterChainAwareHstSiteMapItemHandler)handler).process(newResolvedSiteMapItem, req, res, filterChain) : handler.process(newResolvedSiteMapItem, req, res);
                if (newResolvedSiteMapItem != null) continue;
                logger.debug("handler for '{}' return null. Request processing done. Return null", (Object)handlerConfig.getName());
                return null;
            }
            catch (HstSiteMapItemHandlerException e) {
                logger.error("Exception during executing siteMapItemHandler '" + handlerConfig.getName() + "'");
                throw e;
            }
        }
        return newResolvedSiteMapItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.clientComponentManager != null) {
            try {
                this.clientComponentManager.stop();
                this.clientComponentManager.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.clientComponentManager = null;
            }
        }
    }

    private void log(String msg) {
        this.filterConfig.getServletContext().log(this.filterConfig.getFilterName() + ": " + msg);
    }

    private String getConfigOrContextInitParameter(String paramName, String defaultValue) {
        String value = HstFilter.getInitParameter(this.filterConfig, this.filterConfig.getServletContext(), paramName, defaultValue);
        return value != null ? value.trim() : null;
    }

    private static String getInitParameter(FilterConfig filterConfig, ServletContext servletContext, String paramName, String defaultValue) {
        String value = null;
        if (value == null && filterConfig != null) {
            value = filterConfig.getInitParameter(paramName);
        }
        if (value == null && servletContext != null) {
            value = servletContext.getInitParameter(paramName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String[] splitParamValue(String param, String delimiter) {
        if (param == null) {
            return null;
        }
        String[] tokens = param.split(delimiter);
        ArrayList<String> valuesList = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String value = tokens[i].trim();
            if (value.isEmpty()) continue;
            valuesList.add(value);
        }
        if (!valuesList.isEmpty()) {
            return valuesList.toArray(new String[valuesList.size()]);
        }
        return null;
    }
}

