/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.container;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.container.HstContainerRequest;
import org.hippoecm.hst.util.GenericHttpServletRequestWrapper;
import org.hippoecm.hst.util.HstRequestUtils;

public class HstContainerRequestImpl
extends GenericHttpServletRequestWrapper
implements HstContainerRequest {
    private String pathSuffix;
    private String pathSuffixDelimiter;

    public HstContainerRequestImpl(HttpServletRequest request, String pathSuffixDelimiter) {
        super(request);
        this.pathSuffixDelimiter = pathSuffixDelimiter;
        if (pathSuffixDelimiter == null || "".equals(pathSuffixDelimiter)) {
            return;
        }
        String tempRequestURI = request.getRequestURI();
        int pathSuffixOffset = tempRequestURI.indexOf(pathSuffixDelimiter);
        if (pathSuffixOffset != -1) {
            this.requestURI = tempRequestURI.substring(0, pathSuffixOffset);
            this.pathSuffix = tempRequestURI.substring(pathSuffixOffset + pathSuffixDelimiter.length());
        }
        this.setServletPath("");
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.pathSuffix == null) {
            return super.getRequestURL();
        }
        StringBuffer tempRequestURL = this.requestURL;
        if (tempRequestURL == null) {
            tempRequestURL = super.getRequestURL();
            if (tempRequestURL != null) {
                tempRequestURL.delete(tempRequestURL.indexOf(this.pathSuffixDelimiter), tempRequestURL.length());
            }
            this.requestURL = tempRequestURL;
        }
        return tempRequestURL;
    }

    @Override
    public void setServletPath(String servletPath) {
        super.setServletPath(servletPath);
        this.pathTranslated = this.getRequestURI().substring(this.getContextPath().length());
        if (this.getServletPath() != null) {
            this.pathTranslated = this.pathTranslated.substring(this.getServletPath().length());
        }
        this.pathTranslated = HstRequestUtils.removeAllMatrixParams(this.pathTranslated);
        this.setDecodedPathInfo(this.pathTranslated);
    }

    private void setDecodedPathInfo(String pathTranslated) {
        if (this.getAttribute("org.hippoecm.hst.container.HstContainerRequest.requestURI.isDecoded") == null) {
            String characterEncoding = this.getCharacterEncoding();
            if (characterEncoding == null) {
                characterEncoding = "ISO-8859-1";
            }
            try {
                this.pathInfo = URLDecoder.decode(pathTranslated, characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid character encoding: " + characterEncoding, e);
            }
        }
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        return this.pathTranslated;
    }
}

