/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.parameters;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HstValueType {
    STRING(""),
    BOOLEAN(false),
    INTEGER(0),
    DOUBLE(0.0),
    LONG(0.0),
    DATE;

    static final Logger log;
    private final Object defaultValue;

    private HstValueType() {
        this(null);
    }

    private HstValueType(Object value) {
        this.defaultValue = value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object from(String string) {
        switch (this) {
            case STRING: {
                return string;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(string);
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    log.debug("Could not parse '{}' to a int, taking default value of 0", (Object)string);
                    return 0;
                }
            }
            case LONG: {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException e) {
                    log.debug("Could not parse '{}' to a Long, taking default value of 0", (Object)string);
                    return 0L;
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    log.debug("Could not parse '{}' to a double, taking default value of 0", (Object)string);
                    return 0.0;
                }
            }
            case DATE: {
                Calendar cal = Calendar.getInstance();
                try {
                    cal.setTimeInMillis(Integer.parseInt(string));
                }
                catch (NumberFormatException e) {
                    log.debug("Could not parse '{}' to a long timestamp, returning current date", (Object)string);
                }
                return cal;
            }
        }
        throw new RuntimeException("Could not parse " + string + " to type " + (Object)((Object)this));
    }

    static {
        log = LoggerFactory.getLogger(HstValueType.class);
    }
}

