/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;

public class GenericEventListener
implements EventListener {
    protected String[] skipPaths = new String[]{"/jcr:system", "/hippo:log"};

    public String[] getSkipPaths() {
        if (this.skipPaths == null) {
            return null;
        }
        String[] cloned = new String[this.skipPaths.length];
        System.arraycopy(this.skipPaths, 0, cloned, 0, this.skipPaths.length);
        return cloned;
    }

    public void setSkipPaths(String[] skipPaths) {
        if (skipPaths == null) {
            this.skipPaths = null;
        } else {
            this.skipPaths = new String[skipPaths.length];
            System.arraycopy(skipPaths, 0, this.skipPaths, 0, skipPaths.length);
        }
    }

    protected boolean isEventOnSkippedPath(Event event) throws RepositoryException {
        if (this.skipPaths == null || this.skipPaths.length == 0) {
            return false;
        }
        String eventPath = event.getPath();
        for (String skipPath : this.skipPaths) {
            if (!eventPath.startsWith(skipPath)) continue;
            return true;
        }
        return false;
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                if (this.isEventOnSkippedPath(event)) {
                }
            }
            catch (RepositoryException e) {}
            continue;
            int type = event.getType();
            switch (type) {
                case 1: {
                    this.onNodeAdded(event);
                    break;
                }
                case 2: {
                    this.onNodeRemoved(event);
                    break;
                }
                case 4: {
                    this.onPropertyAdded(event);
                    break;
                }
                case 16: {
                    this.onPropertyChanged(event);
                    break;
                }
                case 8: {
                    this.onPropertyRemoved(event);
                }
            }
        }
    }

    protected void onNodeAdded(Event event) {
    }

    protected void onNodeRemoved(Event event) {
    }

    protected void onPropertyAdded(Event event) {
    }

    protected void onPropertyChanged(Event event) {
    }

    protected void onPropertyRemoved(Event event) {
    }
}

