/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.request.ComponentConfiguration;

public class GenericHstComponent
implements HstComponent {
    public static final String RESOURCE_PATH_BY_RESOURCE_ID = "org.hippoecm.hst.core.component.serveResourcePathByResourceID";
    private ComponentConfiguration componentConfig;

    @Override
    public void init(ServletContext servletContext, ComponentConfiguration componentConfig) throws HstComponentException {
        this.componentConfig = componentConfig;
    }

    @Override
    public void destroy() throws HstComponentException {
    }

    @Override
    public void doAction(HstRequest request, HstResponse response) throws HstComponentException {
    }

    @Override
    public void doBeforeRender(HstRequest request, HstResponse response) throws HstComponentException {
    }

    @Override
    public void doBeforeServeResource(HstRequest request, HstResponse response) throws HstComponentException {
        if (this.componentConfig.getServeResourcePath() == null) {
            String resourceID = request.getResourceID();
            try {
                if (resourceID != null && !resourceID.equals("")) {
                    if (request.getRequestContext().getContainerConfiguration().getBoolean(RESOURCE_PATH_BY_RESOURCE_ID, false)) {
                        if (resourceID.endsWith(".jsp") || resourceID.endsWith(".ftl")) {
                            response.setServeResourcePath(resourceID);
                        } else {
                            response.sendError(404);
                        }
                    } else {
                        response.sendError(404);
                    }
                }
            }
            catch (IOException e) {
                throw new HstComponentException("Unable to set 404 on response after invalid resource path.", e);
            }
        }
    }

    protected ComponentConfiguration getComponentConfiguration() {
        return this.componentConfig;
    }
}

