/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Channel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DEVICE = "default";
    private String id;
    private String name;
    private String type;
    private String hostname;
    private String contextPath;
    private String cmsPreviewPrefix;
    private String mountPath;
    private String url;
    private String hstMountPoint;
    private String hstPreviewMountPoint;
    private String hstConfigPath;
    private String contentRoot;
    private boolean composerModeEnabled;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String channelInfoClassName;
    private String mountId;
    private String locale;
    private boolean fineGrainedLocking;
    private boolean previewHstConfigExists;
    private Set<String> changedBySet = new HashSet<String>();
    private Long lockedOn;
    private String defaultDevice = "default";
    private List<String> devices = Collections.EMPTY_LIST;
    private int hashCode;

    public Channel() {
    }

    public Channel(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws IllegalStateException {
        if (this.id != null && this.id != "") {
            throw new IllegalStateException("Channel id has been already set. It can not be changed.");
        }
        this.id = id;
    }

    public String getContentRoot() {
        return this.contentRoot;
    }

    public void setContentRoot(String contentRoot) {
        this.contentRoot = contentRoot;
    }

    public String getHstMountPoint() {
        return this.hstMountPoint;
    }

    public void setHstMountPoint(String hstMountPoint) {
        this.hstMountPoint = hstMountPoint;
    }

    public void setHstPreviewMountPoint(String hstPreviewMountPoint) {
        this.hstPreviewMountPoint = hstPreviewMountPoint;
    }

    public String getHstPreviewMountPoint() {
        return this.hstPreviewMountPoint;
    }

    public String getHstConfigPath() {
        return this.hstConfigPath;
    }

    public void setHstConfigPath(String hstConfigPath) {
        this.hstConfigPath = hstConfigPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isComposerModeEnabled() {
        return this.composerModeEnabled;
    }

    public void setComposerModeEnabled(boolean composerModeEnabled) {
        this.composerModeEnabled = composerModeEnabled;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getChannelInfoClassName() {
        return this.channelInfoClassName;
    }

    public void setChannelInfoClassName(String channelInfoClassName) {
        this.channelInfoClassName = channelInfoClassName;
    }

    public void setMountId(String mountId) {
        this.mountId = mountId;
    }

    public String getMountId() {
        return this.mountId;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getCmsPreviewPrefix() {
        return this.cmsPreviewPrefix;
    }

    public void setCmsPreviewPrefix(String cmsPreviewPrefix) {
        this.cmsPreviewPrefix = cmsPreviewPrefix;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Deprecated
    public boolean isFineGrainedLocking() {
        return this.fineGrainedLocking;
    }

    @Deprecated
    public void setFineGrainedLocking(boolean fineGrainedLocking) {
        this.fineGrainedLocking = fineGrainedLocking;
    }

    public boolean isPreviewHstConfigExists() {
        return this.previewHstConfigExists;
    }

    public void setPreviewHstConfigExists(boolean previewHstConfigExists) {
        this.previewHstConfigExists = previewHstConfigExists;
    }

    @Deprecated
    public String getLockedBy() {
        if (this.changedBySet != null && this.changedBySet.size() > 0) {
            return this.changedBySet.iterator().next();
        }
        return null;
    }

    @Deprecated
    public void setLockedBy(String lockedBy) {
        if (this.changedBySet != null) {
            this.changedBySet.add(lockedBy);
        } else {
            this.changedBySet = new HashSet<String>(1);
            this.changedBySet.add(lockedBy);
        }
    }

    public Set<String> getChangedBySet() {
        return this.changedBySet;
    }

    public void setChangedBySet(Set<String> changedBySet) {
        this.changedBySet = changedBySet;
    }

    public Long getLockedOn() {
        if (this.fineGrainedLocking) {
            return null;
        }
        return this.lockedOn;
    }

    public void setLockedOn(Long lockedOn) {
        this.lockedOn = lockedOn;
    }

    public String getDefaultDevice() {
        return this.defaultDevice;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public void setDefaultDevice(String defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public void setDevices(List<String> devices) {
        this.devices = devices;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.contextPath != null ? this.contextPath.hashCode() : 0);
        result = 31 * result + (this.cmsPreviewPrefix != null ? this.cmsPreviewPrefix.hashCode() : 0);
        result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.hstMountPoint != null ? this.hstMountPoint.hashCode() : 0);
        result = 31 * result + (this.hstPreviewMountPoint != null ? this.hstPreviewMountPoint.hashCode() : 0);
        result = 31 * result + (this.hstConfigPath != null ? this.hstConfigPath.hashCode() : 0);
        result = 31 * result + (this.contentRoot != null ? this.contentRoot.hashCode() : 0);
        result = 31 * result + (this.composerModeEnabled ? 1 : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.channelInfoClassName != null ? this.channelInfoClassName.hashCode() : 0);
        result = 31 * result + (this.mountId != null ? this.mountId.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.fineGrainedLocking ? 1 : 0);
        result = 31 * result + (this.changedBySet != null ? this.changedBySet.hashCode() : 0);
        result = 31 * result + (this.lockedOn != null ? this.lockedOn.hashCode() : 0);
        result = 31 * result + (this.defaultDevice != null ? this.defaultDevice.hashCode() : 0);
        this.hashCode = result = 31 * result + (this.devices != null ? this.devices.hashCode() : 0);
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Channel)) {
            return false;
        }
        Channel that = (Channel)other;
        return this.id.equals(that.id);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Channel{");
        b.append("id=").append(this.id);
        b.append(",name=").append(this.name);
        b.append(",type=").append(this.type);
        b.append(",url=").append(this.url);
        b.append(",hstConfigPath=").append(this.hstConfigPath);
        b.append(",contentRoot=").append(this.contentRoot);
        b.append(",locale=").append(this.locale);
        b.append(",contextPath=").append(this.contextPath);
        b.append(",cmsPreviewPrefix=").append(this.cmsPreviewPrefix);
        b.append(",mountPath=").append(this.mountPath);
        b.append(",changedBySet=").append(this.changedBySet);
        b.append(",lockedOn=").append(this.lockedOn);
        b.append(",devices=").append(this.devices);
        b.append(",defaultDevice=").append(this.defaultDevice);
        b.append('}');
        return b.toString();
    }
}

