/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.utils;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHtmlExtractor {
    private static final Logger log = LoggerFactory.getLogger(SimpleHtmlExtractor.class);
    private static final int BUF_SIZE = 512;
    private static boolean htmlCleanerInitialized;
    private static HtmlCleaner cleaner;

    private SimpleHtmlExtractor() {
    }

    private static synchronized void initCleaner() {
        if (!htmlCleanerInitialized) {
            cleaner = new HtmlCleaner();
            CleanerProperties props = cleaner.getProperties();
            props.setOmitComments(true);
            props.setOmitXmlDeclaration(true);
            htmlCleanerInitialized = true;
        }
    }

    protected static HtmlCleaner getHtmlCleaner() {
        if (!htmlCleanerInitialized) {
            SimpleHtmlExtractor.initCleaner();
        }
        return cleaner;
    }

    public static String getInnerHtml(String html, String tagName, boolean byHtmlCleaner) {
        if (html == null) {
            return null;
        }
        if (byHtmlCleaner) {
            return SimpleHtmlExtractor.getInnerHtmlByCleaner(html, tagName);
        }
        return SimpleHtmlExtractor.getInnerHtmlSimply(html, tagName);
    }

    public static String getInnerText(String html, String tagName) {
        if (html == null) {
            return null;
        }
        String innerText = "";
        TagNode targetNode = SimpleHtmlExtractor.getTargetTagNode(html, tagName);
        if (targetNode != null) {
            innerText = targetNode.getText().toString();
        }
        return innerText;
    }

    public static String getText(String html) {
        if (html == null) {
            return null;
        }
        try {
            TagNode rootNode = SimpleHtmlExtractor.getHtmlCleaner().clean(html);
            return rootNode.getText().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getInnerHtmlSimply(String html, String tagName) {
        PrintWriter out;
        StringWriter sw;
        BufferedReader br;
        StringReader sr;
        block11: {
            String string;
            if (tagName == null || "".equals(tagName)) {
                tagName = "html";
            }
            tagName = tagName.toUpperCase();
            String startTag = "<" + tagName;
            int startTagLen = startTag.length();
            String endTag = "</" + tagName + ">";
            boolean tagStarted = false;
            int offset = -1;
            sr = null;
            br = null;
            sw = null;
            out = null;
            try {
                sr = new StringReader(html);
                br = new BufferedReader(sr);
                sw = new StringWriter(512);
                out = new PrintWriter(sw);
                String line = br.readLine();
                while (line != null) {
                    block10: {
                        block12: {
                            char ch;
                            if (tagStarted) break block12;
                            offset = line.toUpperCase().indexOf(startTag);
                            if (offset == -1 || (ch = line.charAt(offset + startTagLen)) != '>' && !Character.isWhitespace(ch)) break block10;
                            tagStarted = true;
                            if ((offset = line.indexOf(62, offset + tagName.length())) != -1) {
                                String temp = line.substring(offset + 1);
                                if ((offset = temp.toUpperCase().indexOf(endTag)) == -1) {
                                    out.println(temp);
                                    break block10;
                                } else {
                                    out.print(temp.substring(0, offset));
                                    break;
                                }
                            }
                            break block10;
                        }
                        offset = line.toUpperCase().indexOf(endTag);
                        if (offset != -1) {
                            out.println(line.substring(0, offset));
                            break;
                        }
                        out.println(line);
                    }
                    line = br.readLine();
                }
                if (!tagStarted) break block11;
                out.flush();
                string = sw.toString();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly((Reader)sr);
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly(sw);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)sr);
            IOUtils.closeQuietly((Writer)out);
            IOUtils.closeQuietly((Writer)sw);
            return string;
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)sr);
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((Writer)sw);
        log.debug("Tag '{}' not found. Return null", (Object)tagName);
        return null;
    }

    private static String getInnerHtmlByCleaner(String html, String tagName) {
        TagNode targetNode;
        String tagInnerHtml = null;
        if (html != null && (targetNode = SimpleHtmlExtractor.getTargetTagNode(html, tagName)) != null) {
            tagInnerHtml = SimpleHtmlExtractor.getHtmlCleaner().getInnerHtml(targetNode);
        }
        return tagInnerHtml;
    }

    private static TagNode getTargetTagNode(String html, String tagName) {
        TagNode targetNode = null;
        try {
            TagNode rootNode = SimpleHtmlExtractor.getHtmlCleaner().clean(html);
            if (tagName == null || "".equals(tagName) || tagName.equalsIgnoreCase(rootNode.getName())) {
                return rootNode;
            }
            TagNode[] targetNodes = rootNode.getElementsByName(tagName, true);
            if (targetNodes.length > 0) {
                targetNode = targetNodes[0];
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return targetNode;
    }
}

