/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.content.rewriter.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.content.rewriter.ImageVariant;
import org.hippoecm.hst.content.rewriter.impl.AbstractContentRewriter;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.utils.SimpleHtmlExtractor;
import org.hippoecm.repository.api.HippoWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContentRewriter
extends AbstractContentRewriter<String> {
    private static final Logger log = LoggerFactory.getLogger(SimpleContentRewriter.class);
    protected static final String[] EXTERNALS = new String[]{"http:", "https:", "webdav:", "ftp:", "mailto:", "#", "callto:", "data:"};
    protected static final String LINK_TAG = "<a";
    protected static final String IMG_TAG = "<img";
    protected static final String END_TAG = ">";
    protected static final String HREF_ATTR_NAME = "href=\"";
    protected static final String SRC_ATTR_NAME = "src=\"";
    protected static final String ATTR_END = "\"";
    protected static final Pattern HTML_TAG_PATTERN = Pattern.compile("<html[\\s\\/>]", 2);
    protected static final Pattern BODY_TAG_PATTERN = Pattern.compile("<body[\\s\\/>]", 2);
    private boolean rewritingBinaryLink = false;

    @Override
    public String rewrite(String html, Node node, HstRequestContext requestContext) {
        return this.rewrite(html, node, requestContext, (Mount)null);
    }

    @Override
    public String rewrite(String html, Node node, HstRequestContext requestContext, String targetSiteAlias) {
        Mount targetMount = requestContext.getMount(targetSiteAlias);
        return this.rewrite(html, node, requestContext, targetMount);
    }

    @Override
    public String rewrite(String html, Node node, HstRequestContext requestContext, Mount targetMount) {
        int srcIndexStart;
        boolean appended;
        int endTag;
        int offset;
        int hrefIndexStart;
        StringBuilder sb = null;
        String innerHTML = SimpleHtmlExtractor.getInnerHtml(html, "body", false);
        if (innerHTML == null) {
            if (html == null || HTML_TAG_PATTERN.matcher(html).find() || BODY_TAG_PATTERN.matcher(html).find()) {
                return null;
            }
        } else {
            html = innerHTML;
        }
        if ("".equals(html)) {
            return "";
        }
        int globalOffset = 0;
        while (html.indexOf(LINK_TAG, globalOffset) > -1 && (hrefIndexStart = html.indexOf(HREF_ATTR_NAME, offset = html.indexOf(LINK_TAG, globalOffset))) != -1) {
            int hrefIndexEnd;
            if (sb == null) {
                sb = new StringBuilder(html.length());
            }
            offset = hrefIndexStart += HREF_ATTR_NAME.length();
            endTag = html.indexOf(END_TAG, offset);
            appended = false;
            if (hrefIndexStart < endTag && (hrefIndexEnd = html.indexOf(ATTR_END, hrefIndexStart)) > hrefIndexStart) {
                String documentPath = html.substring(hrefIndexStart, hrefIndexEnd);
                offset = endTag;
                sb.append(html.substring(globalOffset, hrefIndexStart));
                if (this.isExternal(documentPath)) {
                    sb.append(documentPath);
                } else {
                    HstLink href;
                    boolean hasQueryString;
                    String queryString = StringUtils.substringAfter((String)documentPath, (String)"?");
                    boolean bl = hasQueryString = !StringUtils.isEmpty((String)queryString);
                    if (hasQueryString) {
                        documentPath = StringUtils.substringBefore((String)documentPath, (String)"?");
                    }
                    if ((href = this.getDocumentLink(documentPath, node, requestContext, targetMount)) != null && href.getPath() != null) {
                        sb.append(href.toUrlForm(requestContext, this.isFullyQualifiedLinks()));
                    } else {
                        log.warn("Skip href because url is null");
                    }
                    if (hasQueryString) {
                        sb.append('?').append(queryString);
                    }
                }
                sb.append(html.substring(hrefIndexEnd, endTag));
                appended = true;
            }
            if (!appended && offset > globalOffset) {
                sb.append(html.substring(globalOffset, offset));
            }
            globalOffset = offset;
        }
        if (sb != null) {
            sb.append(html.substring(globalOffset, html.length()));
            html = String.valueOf(sb);
            sb = null;
        }
        globalOffset = 0;
        while (html.indexOf(IMG_TAG, globalOffset) > -1 && (srcIndexStart = html.indexOf(SRC_ATTR_NAME, offset = html.indexOf(IMG_TAG, globalOffset))) != -1) {
            int srcIndexEnd;
            if (sb == null) {
                sb = new StringBuilder(html.length());
            }
            offset = srcIndexStart += SRC_ATTR_NAME.length();
            endTag = html.indexOf(END_TAG, offset);
            appended = false;
            if (srcIndexStart < endTag && (srcIndexEnd = html.indexOf(ATTR_END, srcIndexStart)) > srcIndexStart) {
                String srcPath = html.substring(srcIndexStart, srcIndexEnd);
                offset = endTag;
                sb.append(html.substring(globalOffset, srcIndexStart));
                if (this.isExternal(srcPath)) {
                    sb.append(srcPath);
                } else {
                    HstLink binaryLink = this.getBinaryLink(srcPath, node, requestContext, targetMount);
                    if (binaryLink != null && binaryLink.getPath() != null) {
                        sb.append(binaryLink.toUrlForm(requestContext, this.isFullyQualifiedLinks()));
                    } else {
                        log.warn("Could not translate image src. Skip src");
                    }
                }
                sb.append(html.substring(srcIndexEnd, endTag));
                appended = true;
            }
            if (!appended && offset > globalOffset) {
                sb.append(html.substring(globalOffset, offset));
            }
            globalOffset = offset;
        }
        if (sb == null) {
            return html;
        }
        sb.append(html.substring(globalOffset, html.length()));
        return sb.toString();
    }

    protected HstLink getDocumentLink(String path, Node node, HstRequestContext requestContext, Mount targetMount) {
        return this.getLink(path, node, requestContext, targetMount);
    }

    protected HstLink getBinaryLink(String path, Node node, HstRequestContext requestContext, Mount targetMount) {
        this.rewritingBinaryLink = true;
        HstLink link = this.getLink(path, node, requestContext, targetMount);
        this.rewritingBinaryLink = false;
        return link;
    }

    protected HstLink getLink(String path, Node node, HstRequestContext reqContext, Mount targetMount) {
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.warn("UnsupportedEncodingException for documentPath");
        }
        if (path.startsWith("/")) {
            if (targetMount == null) {
                return reqContext.getHstLinkCreator().create(path, reqContext.getResolvedMount().getMount());
            }
            return reqContext.getHstLinkCreator().create(path, targetMount);
        }
        try {
            String variantPath = null;
            boolean fallback = false;
            if (this.rewritingBinaryLink && this.getImageVariant() != null) {
                String[] segments = path.split("/");
                if (segments.length == 3) {
                    ImageVariant imageVariant = this.getImageVariant();
                    fallback = imageVariant.isFallback();
                    if (imageVariant.getReplaces().isEmpty()) {
                        variantPath = segments[0] + "/" + segments[1] + "/" + imageVariant.getName();
                    } else if (imageVariant.getReplaces().contains(segments[2])) {
                        variantPath = segments[0] + "/" + segments[1] + "/" + imageVariant.getName();
                    }
                } else {
                    log.debug("Only know how to get a different variant for links that have 3 segments in its path. Skip variant for path '{}'", (Object)path);
                }
            }
            Node mirrorNode = null;
            String triedPath = path;
            if (variantPath != null) {
                mirrorNode = ((HippoWorkspace)node.getSession().getWorkspace()).getHierarchyResolver().getNode(node, variantPath);
                triedPath = variantPath;
                if (mirrorNode == null) {
                    if (fallback) {
                        log.debug("Could not find the image variant '{}', try the original path '{}'", variantPath, (Object)path);
                        triedPath = path;
                        mirrorNode = ((HippoWorkspace)node.getSession().getWorkspace()).getHierarchyResolver().getNode(node, path);
                    } else {
                        log.debug("Could not find the image variant '{}' and fallback is false", variantPath);
                    }
                }
            } else {
                mirrorNode = ((HippoWorkspace)node.getSession().getWorkspace()).getHierarchyResolver().getNode(node, path);
            }
            if (mirrorNode != null) {
                if (targetMount == null) {
                    return reqContext.getHstLinkCreator().create(mirrorNode, reqContext);
                }
                return reqContext.getHstLinkCreator().create(mirrorNode, targetMount);
            }
            log.warn("Cannot find node '{}' for internal link for document '{}'. Cannot create link", (Object)triedPath, (Object)node.getPath());
        }
        catch (InvalidItemStateException e) {
            log.warn("Unable to rewrite '{}' to proper url : '{}'. Return null", (Object)path, (Object)e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn("Unable to rewrite '{}' to proper url : '{}'. Return null", (Object)path, (Object)e.getMessage());
        }
        return null;
    }

    protected boolean isExternal(String path) {
        for (String prefix : EXTERNALS) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

